/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.ir.Block;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloStatement;
import gololang.ir.LocalReference;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public final class TryCatchFinally
extends GoloStatement<TryCatchFinally> {
    private String exceptionId;
    private Block tryBlock;
    private Block catchBlock;
    private Block finallyBlock;

    private TryCatchFinally(String exceptionId) {
        this.exceptionId = exceptionId;
    }

    public static TryCatchFinally tryCatch() {
        return new TryCatchFinally(null);
    }

    public static TryCatchFinally create(String exceptionName, GoloElement<?> tryBlock, GoloElement<?> catchBlock, GoloElement<?> finallyBlock) {
        return new TryCatchFinally(null).trying(tryBlock).catching(exceptionName, catchBlock).finalizing(finallyBlock);
    }

    @Override
    protected TryCatchFinally self() {
        return this;
    }

    public String getExceptionId() {
        return this.exceptionId;
    }

    public Block getTryBlock() {
        return this.tryBlock;
    }

    public TryCatchFinally trying(Object block) {
        this.tryBlock = this.makeParentOf(Block.of(block));
        return this;
    }

    public Block getCatchBlock() {
        return this.catchBlock;
    }

    public TryCatchFinally catching(String exceptionId, Object block) {
        this.exceptionId = exceptionId;
        return this.catching(block);
    }

    public TryCatchFinally catching(Object block) {
        if (block == null) {
            this.catchBlock = null;
            this.exceptionId = null;
            return this;
        }
        this.catchBlock = this.makeParentOf(Block.of(block));
        this.catchBlock.getReferenceTable().add(LocalReference.of(this.exceptionId).synthetic());
        return this;
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public TryCatchFinally finalizing(Object block) {
        this.finallyBlock = this.makeParentOf(Block.of(block));
        return this;
    }

    public boolean hasFinallyBlock() {
        return this.finallyBlock != null;
    }

    public boolean hasCatchBlock() {
        return this.catchBlock != null;
    }

    public boolean isTryCatchFinally() {
        return this.hasCatchBlock() && this.hasFinallyBlock();
    }

    public boolean isTryCatch() {
        return this.hasCatchBlock() && !this.hasFinallyBlock();
    }

    public boolean isTryFinally() {
        return !this.hasCatchBlock() && this.hasFinallyBlock();
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitTryCatchFinally(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        LinkedList children = new LinkedList();
        children.add(this.tryBlock);
        if (this.catchBlock != null) {
            children.add(this.catchBlock);
        }
        if (this.finallyBlock != null) {
            children.add(this.finallyBlock);
        }
        return children;
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (Objects.equals(original, this.tryBlock)) {
            this.trying(newElement);
        } else if (Objects.equals(original, this.catchBlock)) {
            this.catching(newElement);
        } else if (Objects.equals(original, this.finallyBlock)) {
            this.finalizing(newElement);
        } else {
            throw this.cantReplace(original, newElement);
        }
    }
}

