/*
 * Decompiled with CFR 0.152.
 */
package gololang.ir;

import gololang.Tuple;
import gololang.ir.ExpressionStatement;
import gololang.ir.GoloElement;
import gololang.ir.GoloIrVisitor;
import java.util.Arrays;
import java.util.List;

public final class WhenClause<T extends GoloElement<?>>
extends GoloElement<WhenClause<T>> {
    private ExpressionStatement<?> condition;
    private T action;

    WhenClause(ExpressionStatement<?> condition, T action) {
        this.condition = this.makeParentOf(condition);
        this.setAction(action);
    }

    @Override
    protected WhenClause<T> self() {
        return this;
    }

    public ExpressionStatement<?> condition() {
        return this.condition;
    }

    public T action() {
        return this.action;
    }

    private void setAction(T a) {
        this.action = this.makeParentOf(a);
    }

    public WhenClause<T> then(T action) {
        this.setAction(action);
        return this;
    }

    public String toString() {
        return String.format("when %s then %s", this.condition, this.action);
    }

    @Override
    protected void replaceElement(GoloElement<?> original, GoloElement<?> newElement) {
        if (this.condition.equals(original)) {
            if (!(newElement instanceof ExpressionStatement)) {
                throw WhenClause.cantConvert("ExpressionStatement", newElement);
            }
            this.condition = this.makeParentOf(ExpressionStatement.of(newElement));
        } else if (this.action.equals(original)) {
            GoloElement<?> element = newElement;
            this.setAction(element);
        } else {
            throw this.doesNotContain(original);
        }
    }

    @Override
    public void accept(GoloIrVisitor visitor) {
        visitor.visitWhenClause(this);
    }

    @Override
    public List<GoloElement<?>> children() {
        return Arrays.asList(this.condition, this.action);
    }

    public Tuple destruct() {
        return new Tuple(this.condition, this.action);
    }
}

