/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.golo.doc.DocumentationElement;

class FunctionDocumentation
implements DocumentationElement {
    private String name;
    private int line;
    private String documentation;
    private final List<String> arguments = new LinkedList<String>();
    private boolean augmentation = false;
    private boolean varargs = false;
    private boolean local = false;
    private DocumentationElement parent;

    FunctionDocumentation() {
    }

    @Override
    public String type() {
        return this.local ? "local function" : "function";
    }

    @Override
    public String name() {
        return this.name;
    }

    public FunctionDocumentation name(String v) {
        this.name = v;
        return this;
    }

    @Override
    public String label() {
        StringBuilder sig = new StringBuilder(this.name());
        sig.append("(");
        boolean first = true;
        for (String arg : this.arguments()) {
            if (!first) {
                sig.append(", ");
            }
            sig.append(arg);
            first = false;
        }
        if (this.varargs()) {
            sig.append("...");
        }
        sig.append(")");
        return sig.toString();
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "";
    }

    public FunctionDocumentation documentation(String v) {
        this.documentation = v;
        return this;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public String argument(int i) {
        return this.arguments.get(i);
    }

    public FunctionDocumentation arguments(List<String> v) {
        this.arguments.addAll(v);
        return this;
    }

    public int arity() {
        return this.arguments.size();
    }

    public boolean augmentation() {
        return this.augmentation;
    }

    public FunctionDocumentation augmentation(boolean v) {
        this.augmentation = v;
        return this;
    }

    public boolean varargs() {
        return this.varargs;
    }

    public FunctionDocumentation varargs(boolean v) {
        this.varargs = v;
        return this;
    }

    public boolean local() {
        return this.local;
    }

    public FunctionDocumentation local(boolean v) {
        this.local = v;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public FunctionDocumentation line(int l) {
        this.line = l;
        return this;
    }

    @Override
    public String id() {
        StringBuilder id = new StringBuilder();
        if (this.augmentation) {
            id.append(this.parent.id());
            id.append(".");
        }
        id.append(this.name());
        id.append("_");
        id.append(this.arguments().size());
        if (this.varargs()) {
            id.append("v");
        }
        return id.toString();
    }

    @Override
    public DocumentationElement parent() {
        return this.parent;
    }

    public FunctionDocumentation parent(DocumentationElement p) {
        this.parent = p;
        return this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof FunctionDocumentation)) {
            return false;
        }
        FunctionDocumentation that = (FunctionDocumentation)other;
        return this.name.equals(that.name) && this.local == that.local && this.varargs == that.varargs && this.augmentation == that.augmentation && this.arity() == that.arity();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.local, this.varargs, this.augmentation, this.arity());
    }

    @Override
    public int compareTo(DocumentationElement other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other instanceof FunctionDocumentation) {
            FunctionDocumentation o = (FunctionDocumentation)other;
            int c = this.name.compareToIgnoreCase(o.name);
            if (c == 0) {
                int n = c = this.arity() < o.arity() ? -1 : 1;
                if (c == 0) {
                    int n2 = this.varargs && !o.varargs() ? 1 : (c = this.varargs && o.varargs() ? 0 : -1);
                    if (c == 0) {
                        c = this.parent.compareTo(o.parent);
                    }
                }
            }
            return c;
        }
        return -1 * other.compareTo(this);
    }

    public String toString() {
        return (this.local ? "-" : "+") + this.label();
    }
}

