/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import gololang.ir.AssignmentStatement;
import gololang.ir.Augmentation;
import gololang.ir.BinaryOperation;
import gololang.ir.Block;
import gololang.ir.CaseStatement;
import gololang.ir.ClosureReference;
import gololang.ir.CollectionComprehension;
import gololang.ir.CollectionLiteral;
import gololang.ir.ConditionalBranching;
import gololang.ir.ConstantStatement;
import gololang.ir.Decorator;
import gololang.ir.DestructuringAssignment;
import gololang.ir.ForEachLoopStatement;
import gololang.ir.FunctionInvocation;
import gololang.ir.GoloFunction;
import gololang.ir.GoloIrVisitor;
import gololang.ir.GoloModule;
import gololang.ir.LocalReference;
import gololang.ir.LoopBreakFlowStatement;
import gololang.ir.LoopStatement;
import gololang.ir.MatchExpression;
import gololang.ir.Member;
import gololang.ir.MethodInvocation;
import gololang.ir.ModuleImport;
import gololang.ir.NamedArgument;
import gololang.ir.NamedAugmentation;
import gololang.ir.Noop;
import gololang.ir.ReferenceLookup;
import gololang.ir.ReturnStatement;
import gololang.ir.Struct;
import gololang.ir.ThrowStatement;
import gololang.ir.ToplevelElements;
import gololang.ir.TryCatchFinally;
import gololang.ir.UnaryOperation;
import gololang.ir.Union;
import gololang.ir.UnionValue;
import gololang.ir.WhenClause;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.golo.cli.command.Metadata;
import org.eclipse.golo.compiler.GoloCompiler;
import org.eclipse.golo.compiler.PackageAndClass;
import org.eclipse.golo.doc.AugmentationDocumentation;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.FunctionDocumentation;
import org.eclipse.golo.doc.MemberHolder;
import org.eclipse.golo.doc.NamedAugmentationDocumentation;
import org.eclipse.golo.doc.StructDocumentation;
import org.eclipse.golo.doc.UnionDocumentation;

public class ModuleDocumentation
implements DocumentationElement {
    private String sourceFile;
    private PackageAndClass moduleName;
    private int moduleDefLine;
    private String moduleDocumentation;
    private final Map<String, Integer> imports = new TreeMap<String, Integer>();
    private final Map<String, Integer> moduleStates = new TreeMap<String, Integer>();
    private final SortedSet<FunctionDocumentation> functions = new TreeSet<FunctionDocumentation>();
    private final Map<String, AugmentationDocumentation> augmentations = new TreeMap<String, AugmentationDocumentation>();
    private final SortedSet<StructDocumentation> structs = new TreeSet<StructDocumentation>();
    private final SortedSet<UnionDocumentation> unions = new TreeSet<UnionDocumentation>();
    private final Set<NamedAugmentationDocumentation> namedAugmentations = new TreeSet<NamedAugmentationDocumentation>();

    @Override
    public String type() {
        return "module";
    }

    ModuleDocumentation(GoloModule module) {
        module.accept(new ModuleVisitor());
    }

    ModuleDocumentation() {
    }

    public static ModuleDocumentation load(String filename, GoloCompiler compiler) throws IOException {
        return new ModuleDocumentation(compiler.transform(compiler.parse(filename)));
    }

    public static ModuleDocumentation empty(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Can't create empty module documentation without name");
        }
        ModuleDocumentation doc = new ModuleDocumentation();
        doc.moduleName = PackageAndClass.of(name);
        return doc;
    }

    public boolean isEmpty() {
        return this.moduleStates.isEmpty() && this.functions.isEmpty() && this.augmentations.isEmpty() && this.structs.isEmpty() && this.unions.isEmpty() && this.namedAugmentations.isEmpty();
    }

    public String goloVersion() {
        return Metadata.VERSION;
    }

    public SortedSet<StructDocumentation> structs() {
        return this.structs;
    }

    public SortedSet<UnionDocumentation> unions() {
        return this.unions;
    }

    public SortedSet<FunctionDocumentation> functions() {
        return this.functions(false);
    }

    public SortedSet<FunctionDocumentation> functions(boolean withLocal) {
        if (withLocal) {
            return this.functions;
        }
        TreeSet<FunctionDocumentation> pubFunctions = new TreeSet<FunctionDocumentation>();
        for (FunctionDocumentation f : this.functions) {
            if (f.local()) continue;
            pubFunctions.add(f);
        }
        return pubFunctions;
    }

    public String sourceFile() {
        return this.sourceFile;
    }

    public String moduleName() {
        return this.moduleName.toString();
    }

    public String packageName() {
        return this.moduleName.packageName();
    }

    @Override
    public String label() {
        return this.moduleName.toString();
    }

    @Override
    public String name() {
        return this.moduleName.className();
    }

    @Override
    public String fullName() {
        return this.moduleName.toString();
    }

    @Override
    public String id() {
        return "";
    }

    @Override
    public DocumentationElement parent() {
        return this;
    }

    public int moduleDefLine() {
        return this.moduleDefLine;
    }

    @Override
    public int line() {
        return this.moduleDefLine;
    }

    public String moduleDocumentation() {
        return this.moduleDocumentation != null ? this.moduleDocumentation : "\n";
    }

    public ModuleDocumentation moduleDocumentation(String doc) {
        this.moduleDocumentation = doc;
        return this;
    }

    @Override
    public String documentation() {
        return this.moduleDocumentation();
    }

    public Map<String, Integer> moduleStates() {
        return this.moduleStates;
    }

    public Collection<AugmentationDocumentation> augmentations() {
        return this.augmentations.values();
    }

    public Collection<NamedAugmentationDocumentation> namedAugmentations() {
        return this.namedAugmentations;
    }

    public Map<String, Integer> imports() {
        return this.imports;
    }

    private class ModuleVisitor
    implements GoloIrVisitor {
        private final Deque<Set<FunctionDocumentation>> functionContext = new LinkedList<Set<FunctionDocumentation>>();
        private UnionDocumentation currentUnion;
        private MemberHolder currentMemberHolder;
        private final Deque<DocumentationElement> parents = new LinkedList<DocumentationElement>();

        private ModuleVisitor() {
        }

        @Override
        public void visitModule(GoloModule module) {
            this.functionContext.push(ModuleDocumentation.this.functions);
            this.parents.push(ModuleDocumentation.this);
            ModuleDocumentation.this.moduleName = module.getPackageAndClass();
            ModuleDocumentation.this.moduleDefLine = module.positionInSourceCode().getStartLine();
            ModuleDocumentation.this.moduleDocumentation = module.documentation();
            ModuleDocumentation.this.sourceFile = module.sourceFile();
            module.walk(this);
        }

        @Override
        public void visitModuleImport(ModuleImport moduleImport) {
            if (!moduleImport.isImplicit()) {
                ModuleDocumentation.this.imports.put(moduleImport.getPackageAndClass().toString(), moduleImport.positionInSourceCode().getStartLine());
            }
        }

        @Override
        public void visitStruct(Struct struct) {
            StructDocumentation doc = new StructDocumentation().parent(this.parents.peek()).name(struct.getName()).documentation(struct.documentation()).line(struct.positionInSourceCode().getStartLine());
            ModuleDocumentation.this.structs.add(doc);
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            struct.walk(this);
            this.parents.pop();
            this.currentMemberHolder = null;
        }

        @Override
        public void visitUnion(Union union) {
            this.currentUnion = new UnionDocumentation().parent(this.parents.peek()).name(union.getName()).documentation(union.documentation()).line(union.positionInSourceCode().getStartLine());
            ModuleDocumentation.this.unions.add(this.currentUnion);
            this.parents.push(this.currentUnion);
            union.walk(this);
            this.parents.pop();
        }

        @Override
        public void visitUnionValue(UnionValue value) {
            UnionDocumentation.UnionValueDocumentation doc = this.currentUnion.addValue(value.getName()).parent(this.parents.peek()).documentation(value.documentation()).line(value.positionInSourceCode().getStartLine());
            this.currentMemberHolder = doc;
            this.parents.push(doc);
            value.walk(this);
            this.parents.pop();
            this.currentMemberHolder = null;
        }

        @Override
        public void visitAugmentation(Augmentation augment) {
            String target = augment.getTarget().toString();
            if (!ModuleDocumentation.this.augmentations.containsKey(target)) {
                ModuleDocumentation.this.augmentations.put(target, new AugmentationDocumentation().target(target).parent(this.parents.peek()).augmentationNames(augment.getNames()).line(augment.positionInSourceCode().getStartLine()));
            }
            AugmentationDocumentation ad = (AugmentationDocumentation)ModuleDocumentation.this.augmentations.get(target);
            if (augment.documentation() != null && !augment.documentation().isEmpty()) {
                ad.documentation(String.join((CharSequence)"\n", ad.documentation(), augment.documentation()));
            }
            this.functionContext.push(ad);
            this.parents.push(ad);
            augment.walk(this);
            this.functionContext.pop();
            this.parents.pop();
        }

        @Override
        public void visitNamedAugmentation(NamedAugmentation augment) {
            NamedAugmentationDocumentation augmentDoc = new NamedAugmentationDocumentation().parent(this.parents.peek()).name(augment.getName()).documentation(augment.documentation()).line(augment.positionInSourceCode().getStartLine());
            ModuleDocumentation.this.namedAugmentations.add(augmentDoc);
            this.functionContext.push(augmentDoc);
            this.parents.push(augmentDoc);
            augment.walk(this);
            this.functionContext.pop();
            this.parents.pop();
        }

        @Override
        public void visitFunction(GoloFunction function) {
            if (!"<clinit>".equals(function.getName())) {
                this.functionContext.peek().add(new FunctionDocumentation().parent(this.parents.peek()).name(function.getName()).documentation(function.documentation()).augmentation(function.isInAugment()).line(function.positionInSourceCode().getStartLine()).local(function.isLocal()).arguments(function.getParameterNames()).varargs(function.isVarargs()));
            }
        }

        @Override
        public void visitLocalReference(LocalReference localRef) {
            if (localRef.isModuleState()) {
                ModuleDocumentation.this.moduleStates.put(localRef.getName(), localRef.positionInSourceCode().getStartLine());
            }
        }

        @Override
        public void visitMember(Member member) {
            this.currentMemberHolder.addMember(member.getName()).parent(this.parents.peek()).documentation(member.documentation()).line(member.positionInSourceCode().getStartLine());
        }

        @Override
        public void visitDecorator(Decorator decorator) {
        }

        @Override
        public void visitBlock(Block block) {
        }

        @Override
        public void visitConstantStatement(ConstantStatement constantStatement) {
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStatement) {
        }

        @Override
        public void visitFunctionInvocation(FunctionInvocation functionInvocation) {
        }

        @Override
        public void visitMethodInvocation(MethodInvocation methodInvocation) {
        }

        @Override
        public void visitAssignmentStatement(AssignmentStatement assignmentStatement) {
        }

        @Override
        public void visitDestructuringAssignment(DestructuringAssignment assignment) {
        }

        @Override
        public void visitReferenceLookup(ReferenceLookup referenceLookup) {
        }

        @Override
        public void visitConditionalBranching(ConditionalBranching conditionalBranching) {
        }

        @Override
        public void visitBinaryOperation(BinaryOperation binaryOperation) {
        }

        @Override
        public void visitUnaryOperation(UnaryOperation unaryOperation) {
        }

        @Override
        public void visitLoopStatement(LoopStatement loopStatement) {
        }

        @Override
        public void visitForEachLoopStatement(ForEachLoopStatement foreachStatement) {
        }

        @Override
        public void visitCaseStatement(CaseStatement caseStatement) {
        }

        @Override
        public void visitMatchExpression(MatchExpression matchExpression) {
        }

        @Override
        public void visitWhenClause(WhenClause<?> whenClause) {
        }

        @Override
        public void visitThrowStatement(ThrowStatement throwStatement) {
        }

        @Override
        public void visitTryCatchFinally(TryCatchFinally tryCatchFinally) {
        }

        @Override
        public void visitClosureReference(ClosureReference closureReference) {
        }

        @Override
        public void visitLoopBreakFlowStatement(LoopBreakFlowStatement loopBreakFlowStatement) {
        }

        @Override
        public void visitCollectionLiteral(CollectionLiteral collectionLiteral) {
        }

        @Override
        public void visitCollectionComprehension(CollectionComprehension collectionComprehension) {
        }

        @Override
        public void visitNamedArgument(NamedArgument namedArgument) {
        }

        @Override
        public void visitNoop(Noop noop) {
        }

        @Override
        public void visitToplevelElements(ToplevelElements toplevels) {
            toplevels.walk(this);
        }
    }
}

