/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.doc;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.golo.doc.DocumentationElement;
import org.eclipse.golo.doc.MemberDocumentation;
import org.eclipse.golo.doc.MemberHolder;

class UnionDocumentation
implements DocumentationElement {
    private String name;
    private String documentation;
    private int line;
    private final List<UnionValueDocumentation> values = new LinkedList<UnionValueDocumentation>();
    private DocumentationElement parent;

    UnionDocumentation() {
    }

    @Override
    public String type() {
        return "union";
    }

    @Override
    public String name() {
        return this.name;
    }

    public UnionDocumentation name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DocumentationElement parent() {
        return this.parent;
    }

    public UnionDocumentation parent(DocumentationElement p) {
        this.parent = p;
        return this;
    }

    @Override
    public String documentation() {
        return this.documentation != null ? this.documentation : "\n";
    }

    public UnionDocumentation documentation(String doc) {
        this.documentation = doc;
        return this;
    }

    @Override
    public int line() {
        return this.line;
    }

    public UnionDocumentation line(int l) {
        this.line = l;
        return this;
    }

    public List<UnionValueDocumentation> values() {
        return Collections.unmodifiableList(this.values);
    }

    public UnionDocumentation values(Collection<UnionValueDocumentation> v) {
        this.values.addAll(v);
        return this;
    }

    public boolean addValue(UnionValueDocumentation v) {
        return this.values.add(v);
    }

    public UnionValueDocumentation addValue(String name) {
        UnionValueDocumentation v = new UnionValueDocumentation();
        v.parent(this);
        v.name(name);
        this.values.add(v);
        return v;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionDocumentation)) {
            return false;
        }
        return this.name.equals(((UnionDocumentation)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static final class UnionValueDocumentation
    implements DocumentationElement,
    MemberHolder {
        private String name;
        private String documentation;
        private int line;
        private final List<MemberDocumentation> members = new LinkedList<MemberDocumentation>();
        private DocumentationElement parent;

        @Override
        public String type() {
            return "union value";
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String fullName() {
            return this.parent.fullName() + '$' + this.name;
        }

        @Override
        public String label() {
            return this.name;
        }

        @Override
        public DocumentationElement parent() {
            return this.parent;
        }

        public UnionValueDocumentation parent(DocumentationElement p) {
            this.parent = p;
            return this;
        }

        public UnionValueDocumentation name(String n) {
            this.name = n;
            return this;
        }

        @Override
        public String documentation() {
            return this.documentation != null ? this.documentation : "\n";
        }

        public UnionValueDocumentation documentation(String doc) {
            this.documentation = doc;
            return this;
        }

        @Override
        public int line() {
            return this.line;
        }

        public UnionValueDocumentation line(int l) {
            this.line = l;
            return this;
        }

        @Override
        public List<MemberDocumentation> members() {
            return Collections.unmodifiableList(this.members);
        }

        @Override
        public UnionValueDocumentation members(Collection<MemberDocumentation> m) {
            this.members.addAll(m);
            return this;
        }

        @Override
        public MemberDocumentation addMember(String name) {
            MemberDocumentation doc = new MemberDocumentation().name(name);
            this.members.add(doc);
            return doc;
        }
    }
}

