/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Optional;
import org.eclipse.golo.runtime.DecoratorsHelper;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.NamedArgumentsHelper;

abstract class MethodFinder {
    protected final MethodInvocation invocation;
    protected final MethodHandles.Lookup lookup;
    protected final Class<?> callerClass;

    MethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        this.invocation = invocation;
        this.lookup = lookup;
        this.callerClass = lookup.lookupClass();
    }

    abstract MethodHandle find();

    public MethodHandle reorderArguments(Method method, MethodHandle handle) {
        return NamedArgumentsHelper.reorderArguments(method.getName(), NamedArgumentsHelper.getParameterNames(method), handle, this.invocation.argumentNames(), 1, 1);
    }

    protected Optional<MethodHandle> toMethodHandle(Method method) {
        MethodHandle target = null;
        if (DecoratorsHelper.isMethodDecorated(method)) {
            target = DecoratorsHelper.getDecoratedMethodHandle(this.lookup, method, this.invocation.arity());
        } else {
            try {
                target = this.lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                return Optional.empty();
            }
        }
        return Optional.of(this.invocation.coerce(this.reorderArguments(method, target)));
    }
}

