/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.golo.runtime;

import gololang.GoloStruct;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.golo.runtime.Extractors;
import org.eclipse.golo.runtime.FunctionCallSupport;
import org.eclipse.golo.runtime.MethodFinder;
import org.eclipse.golo.runtime.MethodInvocation;
import org.eclipse.golo.runtime.TypeMatching;

class RegularMethodFinder
extends MethodFinder {
    private final boolean makeAccessible;

    RegularMethodFinder(MethodInvocation invocation, MethodHandles.Lookup lookup) {
        super(invocation, lookup);
        this.makeAccessible = !Modifier.isPublic(invocation.receiverClass().getModifiers());
    }

    @Override
    public MethodHandle find() {
        return Stream.concat(this.findInMethods().map(this::checkDeprecation).map(this::toMethodHandle), this.findInFields().map(this::checkDeprecation).map(this::toMethodHandle)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(null);
    }

    public boolean isOverloaded() {
        return Extractors.getMethods(this.invocation.receiverClass()).filter(this::overloadMatch).count() > 1L;
    }

    private boolean overloadMatch(Method m) {
        return Extractors.isPublic(m) && Extractors.isConcrete(m) && m.getName().equals(this.invocation.name()) && m.getParameterCount() + 1 == this.invocation.arity() || m.isVarArgs() && m.getParameterCount() <= this.invocation.arity();
    }

    private Optional<MethodHandle> toMethodHandle(Field field) {
        if (this.makeAccessible) {
            field.setAccessible(true);
        }
        try {
            if (this.invocation.arity() == 1) {
                return Optional.of(this.lookup.unreflectGetter(field).asType(this.invocation.type()));
            }
            return Optional.of(MethodHandles.filterReturnValue(this.lookup.unreflectSetter(field), MethodHandles.constant(this.invocation.receiverClass(), this.invocation.arguments()[0])).asType(this.invocation.type()));
        }
        catch (IllegalAccessException e) {
            return Optional.empty();
        }
    }

    @Override
    protected Optional<MethodHandle> toMethodHandle(Method method) {
        if (this.makeAccessible || this.isValidPrivateStructAccess(method)) {
            method.setAccessible(true);
        }
        return super.toMethodHandle(method).map(handle -> FunctionCallSupport.insertSAMFilter(handle, this.lookup, method.getParameterTypes(), 1));
    }

    private boolean isValidPrivateStructAccess(Method method) {
        Object receiver = this.invocation.arguments()[0];
        if (!(receiver instanceof GoloStruct)) {
            return false;
        }
        String receiverClassName = receiver.getClass().getName();
        String callerClassName = this.callerClass.getName();
        return method.getName().equals(this.invocation.name()) && Modifier.isPrivate(method.getModifiers()) && (receiverClassName.startsWith(callerClassName) || callerClassName.equals(RegularMethodFinder.reverseStructAugmentation(receiverClassName))) && TypeMatching.argumentsMatch(method, this.invocation.arguments());
    }

    private static String reverseStructAugmentation(String receiverClassName) {
        return receiverClassName.substring(0, receiverClassName.indexOf(".types")) + "$" + receiverClassName.replace('.', '$');
    }

    protected Stream<Method> findInMethods() {
        return Extractors.getMethods(this.invocation.receiverClass()).filter(m -> this.invocation.match((Method)m) || this.isValidPrivateStructAccess((Method)m));
    }

    private Stream<Field> findInFields() {
        if (this.invocation.arity() > 3) {
            return Stream.empty();
        }
        return Extractors.getFields(this.invocation.receiverClass()).filter(this::isMatchingField);
    }

    private boolean isMatchingField(Field field) {
        return field.getName().equals(this.invocation.name()) && !Modifier.isStatic(field.getModifiers());
    }

    private Field checkDeprecation(Field field) {
        return Extractors.checkDeprecation(this.callerClass, field);
    }

    private Method checkDeprecation(Method method) {
        return Extractors.checkDeprecation(this.callerClass, method);
    }
}

