/**
 * Copyright (c) 2018 Aston University.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 3.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-3.0
 * 
 * Contributors:
 *   Antonio Garcia-Dominguez - initial API and implementation
 */
package org.eclipse.hawk.examples.docgen.model.document;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Author</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.hawk.examples.docgen.model.document.Author#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hawk.examples.docgen.model.document.Author#getKnows <em>Knows</em>}</li>
 *   <li>{@link org.eclipse.hawk.examples.docgen.model.document.Author#getIsKnownBy <em>Is Known By</em>}</li>
 * </ul>
 *
 * @see org.eclipse.hawk.examples.docgen.model.document.DocumentPackage#getAuthor()
 * @model
 * @generated
 */
public interface Author extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hawk.examples.docgen.model.document.DocumentPackage#getAuthor_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hawk.examples.docgen.model.document.Author#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Knows</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hawk.examples.docgen.model.document.Author}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hawk.examples.docgen.model.document.Author#getIsKnownBy <em>Is Known By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Knows</em>' reference list.
	 * @see org.eclipse.hawk.examples.docgen.model.document.DocumentPackage#getAuthor_Knows()
	 * @see org.eclipse.hawk.examples.docgen.model.document.Author#getIsKnownBy
	 * @model opposite="isKnownBy"
	 * @generated
	 */
	EList<Author> getKnows();

	/**
	 * Returns the value of the '<em><b>Is Known By</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hawk.examples.docgen.model.document.Author}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hawk.examples.docgen.model.document.Author#getKnows <em>Knows</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Known By</em>' reference list.
	 * @see org.eclipse.hawk.examples.docgen.model.document.DocumentPackage#getAuthor_IsKnownBy()
	 * @see org.eclipse.hawk.examples.docgen.model.document.Author#getKnows
	 * @model opposite="knows"
	 * @generated
	 */
	EList<Author> getIsKnownBy();

} // Author
