/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnDiffStatus;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnReceivingOperation;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiffSummarize
extends SvnReceivingOperation<SvnDiffStatus> {
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private SvnTarget source;
    private SVNRevision startRevision;
    private SVNRevision endRevision;
    private boolean ignoreAncestry;

    protected SvnDiffSummarize(SvnOperationFactory factory) {
        super(factory);
    }

    public void setSource(SvnTarget source, SVNRevision start, SVNRevision end) {
        this.source = source;
        this.startRevision = start;
        this.endRevision = end;
        if (source != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget source1, SvnTarget source2) {
        this.firstSource = source1;
        this.secondSource = source2;
        if (this.firstSource != null) {
            this.setSource(null, null, null);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SVNRevision getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision getEndRevision() {
        return this.endRevision;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource() != null && this.getSource().isFile()) {
            return this.getSource().getFile();
        }
        if (this.getFirstSource() != null && this.getFirstSource().isFile()) {
            return this.getFirstSource().getFile();
        }
        if (this.getSecondSource() != null && this.getSecondSource().isFile()) {
            return this.getSecondSource().getFile();
        }
        return null;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        if (this.getSource() == null || this.getSource().getPegRevision() == null || this.getSource().getPegRevision() == SVNRevision.UNDEFINED) {
            SvnTarget firstSource = this.getFirstSource();
            SvnTarget secondSource = this.getSecondSource();
            this.ensureArgumentsAreValid(firstSource.getURL(), firstSource.getFile(), firstSource.getPegRevision(), secondSource.getURL(), secondSource.getFile(), secondSource.getPegRevision(), null);
        } else {
            SvnTarget source = this.getSource();
            this.ensureArgumentsAreValid(source.getURL(), source.getFile(), this.getStartRevision(), source.getURL(), source.getFile(), this.getEndRevision(), source.getPegRevision());
        }
    }

    private void ensureArgumentsAreValid(SVNURL url1, File path1, SVNRevision revision1, SVNURL url2, File path2, SVNRevision revision2, SVNRevision pegRevision) throws SVNException {
        boolean isRepos2;
        boolean isRepos1;
        SVNErrorMessage err;
        boolean isPath2Local;
        if (pegRevision == null) {
            pegRevision = SVNRevision.UNDEFINED;
        }
        this.ensureRevisionIsValid(revision1);
        this.ensureRevisionIsValid(revision2);
        boolean isPath1Local = this.startRevision == SVNRevision.WORKING || this.startRevision == SVNRevision.BASE;
        boolean bl = isPath2Local = this.endRevision == SVNRevision.WORKING || this.endRevision == SVNRevision.BASE;
        if (pegRevision != SVNRevision.UNDEFINED) {
            if (isPath1Local && isPath2Local) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "At least one revision must be non-local for a pegged diff");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            isRepos1 = !isPath1Local;
            isRepos2 = !isPath2Local;
        } else {
            isRepos1 = !isPath1Local || url1 != null;
            boolean bl2 = isRepos2 = !isPath2Local || url2 != null;
        }
        if (!isRepos1 || !isRepos2) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Summarizing diff can only compare repository to repository");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    private void ensureRevisionIsValid(SVNRevision revision) throws SVNException {
        boolean revisionIsValid;
        boolean bl = revisionIsValid = revision != null && revision.isValid();
        if (!revisionIsValid) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

