/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.wizard;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IHawkFactory;
import org.eclipse.hawk.core.util.HawkConfig;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.hawk.osgiserver.HModel;
import org.eclipse.hawk.ui2.util.HUIManager;
import org.eclipse.hawk.ui2.view.HView;
import org.eclipse.hawk.ui2.wizard.HWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class HWizard
extends Wizard
implements INewWizard {
    private HWizardPage page;
    private ISelection selection;
    private HModel result;

    public HWizard() {
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.page = new HWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            final String name = this.page.getHawkName();
            final String folder = this.page.getContainerName();
            final String dbType = this.page.getDBID();
            final List<String> plugins = this.page.getSelectedAdvancedPlugins();
            final String location = this.page.getLocation();
            final IHawkFactory factory = this.page.getFactory();
            final int maxDelay = this.page.getMaxDelay();
            final int minDelay = this.page.getMinDelay();
            final boolean isNew = this.page.isNew();
            final ICredentialsStore credStore = HUIManager.getInstance().getCredentialsStore();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            HWizard.this.doFinish(name, new File(folder), location, dbType, plugins, monitor, credStore, factory, minDelay, maxDelay, isNew);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public HModel getResult() {
        return this.result;
    }

    private void doFinish(String name, File storageFolder, String location, String dbType, List<String> plugins, IProgressMonitor monitor, ICredentialsStore credStore, IHawkFactory factory, int minDelay, int maxDelay, boolean isNew) throws Exception {
        if (isNew) {
            System.out.println("creating new hawk...");
            this.result = HModel.create((IHawkFactory)factory, (String)name, (File)storageFolder, (String)location, (String)dbType, plugins, (HManager)HUIManager.getInstance(), (ICredentialsStore)credStore, (int)minDelay, (int)maxDelay);
        } else {
            System.out.println("loading hawk metadata...");
            HawkConfig hc = new HawkConfig(name, storageFolder.getCanonicalPath(), location, factory.getClass().getName(), plugins);
            HUIManager manager = HUIManager.getInstance();
            this.result = HModel.load((HawkConfig)hc, (HManager)manager);
            manager.addHawk(this.result);
        }
        monitor.beginTask("Creating ", 2);
        monitor.worked(1);
        monitor.setTaskName("Opening Hawk interface...");
        HView.updateAsync(this.getShell().getDisplay());
        HUIManager.getInstance().saveHawkToMetadata(this.result);
        monitor.worked(1);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

