/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.hono.client.amqp.connection.ConnectionLifecycle;
import org.eclipse.hono.client.amqp.connection.DisconnectListener;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.ReconnectListener;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.util.ServiceClient;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.MessagingClient;
import org.eclipse.hono.util.MessagingType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceClient
implements ConnectionLifecycle<HonoConnection>,
MessagingClient,
ServiceClient,
Lifecycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final HonoConnection connection;
    protected final SendMessageSampler.Factory samplerFactory;

    protected AbstractServiceClient(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        this.connection = Objects.requireNonNull(connection);
        this.connection.addDisconnectListener((T con) -> this.onDisconnect());
        this.samplerFactory = Objects.requireNonNull(samplerFactory);
    }

    @Override
    public final MessagingType getMessagingType() {
        return MessagingType.amqp;
    }

    protected final Span newChildSpan(SpanContext parent, String operationName) {
        return this.newSpan(parent, "child_of", operationName);
    }

    protected final Span newFollowingSpan(SpanContext parent, String operationName) {
        return this.newSpan(parent, "follows_from", operationName);
    }

    private Span newSpan(SpanContext parent, String referenceType, String operationName) {
        return TracingHelper.buildSpan(this.connection.getTracer(), parent, operationName, referenceType).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), "hono-client").withTag(Tags.PEER_HOSTNAME.getKey(), this.connection.getConfig().getHost()).withTag(Tags.PEER_PORT.getKey(), this.connection.getConfig().getPort()).withTag(TracingHelper.TAG_PEER_CONTAINER.getKey(), this.connection.getRemoteContainerId()).start();
    }

    @Override
    public final void addDisconnectListener(DisconnectListener<HonoConnection> listener) {
        this.connection.addDisconnectListener(listener);
    }

    @Override
    public final void addReconnectListener(ReconnectListener<HonoConnection> listener) {
        this.connection.addReconnectListener(listener);
    }

    @Override
    public Future<HonoConnection> connect() {
        return this.connection.connect();
    }

    @Override
    public final Future<Void> isConnected() {
        return this.connection.isConnected();
    }

    @Override
    public final Future<Void> isConnected(long waitForCurrentConnectAttemptTimeout) {
        return this.connection.isConnected(waitForCurrentConnectAttemptTimeout);
    }

    public final long getDefaultConnectionCheckTimeout() {
        return this.connection.getConfig().getLinkEstablishmentTimeout();
    }

    @Override
    public void disconnect() {
        this.connection.disconnect();
    }

    @Override
    public void disconnect(Handler<AsyncResult<Void>> completionHandler) {
        this.connection.disconnect(completionHandler);
    }

    protected void onDisconnect() {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler readinessHandler) {
        readinessHandler.register(String.format("connection-to-%s-%s", this.connection.getConfig().getServerRole(), UUID.randomUUID()), status -> this.connection.isConnected().onSuccess(ok -> status.tryComplete(Status.OK())).onFailure(t -> status.tryComplete(Status.KO())));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler livenessHandler) {
    }

    @Override
    public Future<Void> start() {
        return this.connection.connect().onSuccess(ok -> this.log.info("connection to {} endpoint has been established", (Object)this.connection.getConfig().getServerRole())).onFailure(t -> this.log.warn("failed to establish connection to {} endpoint", (Object)this.connection.getConfig().getServerRole(), t)).mapEmpty();
    }

    @Override
    public Future<Void> stop() {
        Promise<Void> result = Promise.promise();
        this.connection.shutdown(result);
        return result.future().onSuccess(ok -> this.log.info("connection to {} endpoint has been closed", (Object)this.connection.getConfig().getServerRole()));
    }
}

