/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.observation;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import java.util.stream.Collectors;

public class DefaultMeterObservationHandler
implements MeterObservationHandler<Observation.Context> {
    private final MeterRegistry meterRegistry;

    public DefaultMeterObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onStart(Observation.Context context) {
        LongTaskTimer.Sample longTaskSample = LongTaskTimer.builder(context.getName() + ".active").tags(this.createTags(context)).register(this.meterRegistry).start();
        context.put(LongTaskTimer.Sample.class, longTaskSample);
        Timer.Sample sample = Timer.start(this.meterRegistry);
        context.put(Timer.Sample.class, sample);
    }

    @Override
    public void onStop(Observation.Context context) {
        Timer.Sample sample = (Timer.Sample)context.getRequired(Timer.Sample.class);
        sample.stop(((Timer.Builder)((Timer.Builder)Timer.builder(context.getName()).tags((Iterable)this.createErrorTags(context))).tags((Iterable)this.createTags(context))).register(this.meterRegistry));
        LongTaskTimer.Sample longTaskSample = (LongTaskTimer.Sample)context.getRequired(LongTaskTimer.Sample.class);
        longTaskSample.stop();
    }

    @Override
    public void onEvent(Observation.Event event, Observation.Context context) {
        Counter.builder(context.getName() + "." + event.getName()).tags(this.createTags(context)).register(this.meterRegistry).increment();
    }

    private Tags createErrorTags(Observation.Context context) {
        return Tags.of("error", this.getErrorValue(context));
    }

    private String getErrorValue(Observation.Context context) {
        Throwable error = context.getError();
        return error != null ? error.getClass().getSimpleName() : "none";
    }

    private Tags createTags(Observation.Context context) {
        return Tags.of(context.getLowCardinalityKeyValues().stream().map(tag -> Tag.of(tag.getKey(), tag.getValue())).collect(Collectors.toList()));
    }
}

