/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.annotations;

public enum ConfigPhase {
    BUILD_TIME(true, false, false, "Build time"),
    BUILD_AND_RUN_TIME_FIXED(true, true, false, "Build time and run time fixed"),
    BOOTSTRAP(false, true, true, "Bootstrap"),
    RUN_TIME(false, true, true, "Run time");

    private final boolean availableAtBuild;
    private final boolean availableAtRun;
    private final boolean readAtMain;
    private final String name;

    private ConfigPhase(boolean availableAtBuild, boolean availableAtRun, boolean readAtMain, String name) {
        this.availableAtBuild = availableAtBuild;
        this.availableAtRun = availableAtRun;
        this.readAtMain = readAtMain;
        this.name = name;
    }

    public boolean isAvailableAtBuild() {
        return this.availableAtBuild;
    }

    public boolean isAvailableAtRun() {
        return this.availableAtRun;
    }

    public boolean isReadAtStaticInit() {
        return this.isAvailableAtBuild() && this.isAvailableAtRun();
    }

    public boolean isReadAtMain() {
        return this.readAtMain;
    }

    public String toString() {
        return this.name;
    }
}

