/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.HalfSerializer;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class StrictMultiSubscriber<T>
implements MultiSubscriber<T>,
Subscription,
ContextSupport {
    private final AtomicInteger wip = new AtomicInteger();
    private final Subscriber<? super T> downstream;
    private final AtomicReference<Throwable> failure;
    private final AtomicLong requested;
    private final AtomicReference<Subscription> upstream;
    private final AtomicBoolean once;
    volatile boolean done;

    public StrictMultiSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
        this.failure = new AtomicReference();
        this.requested = new AtomicLong();
        this.upstream = new AtomicReference();
        this.once = new AtomicBoolean();
    }

    @Override
    public void request(long n) {
        if (n <= 0L) {
            this.cancel();
            this.onError(new IllegalArgumentException("Reactive Streams Rule 3.9 violated: request must be positive, but was " + n));
        } else {
            Subscriptions.requestIfNotNullOrAccumulate(this.upstream, this.requested, n);
        }
    }

    @Override
    public void cancel() {
        if (!this.done) {
            Subscriptions.cancel(this.upstream);
        }
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.once.compareAndSet(false, true)) {
            this.downstream.onSubscribe(this);
            Subscriptions.setIfEmptyAndRequest(this.upstream, this.requested, s);
        } else {
            s.cancel();
            this.cancel();
            this.onError(new IllegalStateException("Reactive Streams Rule 2.12 violated: onSubscribe must be called at most once"));
        }
    }

    @Override
    public void onItem(T t) {
        Objects.requireNonNull(t);
        HalfSerializer.onNext(this.downstream, t, this.wip, this.failure);
    }

    @Override
    public void onFailure(Throwable t) {
        this.done = true;
        HalfSerializer.onError(this.downstream, t, this.wip, this.failure);
    }

    @Override
    public void onCompletion() {
        this.done = true;
        HalfSerializer.onComplete(this.downstream, this.wip, this.failure);
    }

    @Override
    public Context context() {
        if (this.downstream instanceof ContextSupport) {
            return ((ContextSupport)((Object)this.downstream)).context();
        }
        return Context.empty();
    }
}

