/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.common.tracing;

import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.kafka.client.common.tracing.TraceContext;
import java.util.function.Function;

public enum TraceTags {
    PEER_ADDRESS("peer.address", q -> q.address),
    PEER_HOSTNAME("peer.hostname", q -> q.hostname),
    PEER_PORT("peer.port", q -> q.port),
    PEER_SERVICE("peer.service", q -> "kafka"),
    BUS_DESTINATION("message_bus.destination", q -> q.topic);

    static final TagExtractor<TraceContext> TAG_EXTRACTOR;
    final String name;
    final Function<TraceContext, String> fn;

    private TraceTags(String name, Function<TraceContext, String> fn) {
        this.name = name;
        this.fn = fn;
    }

    static {
        TAG_EXTRACTOR = new TagExtractor<TraceContext>(){
            private final TraceTags[] TAGS = TraceTags.values();

            @Override
            public int len(TraceContext obj) {
                return this.TAGS.length;
            }

            @Override
            public String name(TraceContext obj, int index) {
                return this.TAGS[index].name;
            }

            @Override
            public String value(TraceContext obj, int index) {
                return this.TAGS[index].fn.apply(obj);
            }
        };
    }
}

