package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.ConnectorKindMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.ConnectorKindQuerySpecification;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorKind;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.connectorKind pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ConnectorKindMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * //  Fixed
 * 
 * 
 * (if end-{@literal >}exists(
 *         role.oclIsKindOf(Port) 
 *         and partWithPort-{@literal >}isEmpty()
 *         and not role.oclAsType(Port).isBehavior)
 * then ConnectorKind::delegation 
 * else ConnectorKind::assembly 
 * endif)
 * 
 * {@literal @}Surrogate(feature = "kind")
 * {@literal @}QueryExplorer(checked = false)
 * pattern connectorKind(
 *     self : Connector,
 *     kind : ConnectorKind
 * ) {
 *     find connectorKindDelegation(self);
 *     kind == ConnectorKind::delegation;
 * } or {
 *     neg find connectorKindDelegation(self);
 *     kind == ConnectorKind::assembly;
 * }
 * </pre></code>
 * 
 * @see ConnectorKindMatch
 * @see ConnectorKindProcessor
 * @see ConnectorKindQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ConnectorKindMatcher extends BaseMatcher<ConnectorKindMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ConnectorKindMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    ConnectorKindMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new ConnectorKindMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_KIND = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(ConnectorKindMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public ConnectorKindMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public ConnectorKindMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @return matches represented as a ConnectorKindMatch object.
   * 
   */
  public Collection<ConnectorKindMatch> getAllMatches(final Connector pSelf, final ConnectorKind pKind) {
    return rawGetAllMatches(new Object[]{pSelf, pKind});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @return a match represented as a ConnectorKindMatch object, or null if no match is found.
   * 
   */
  public ConnectorKindMatch getOneArbitraryMatch(final Connector pSelf, final ConnectorKind pKind) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pKind});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Connector pSelf, final ConnectorKind pKind) {
    return rawHasMatch(new Object[]{pSelf, pKind});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Connector pSelf, final ConnectorKind pKind) {
    return rawCountMatches(new Object[]{pSelf, pKind});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Connector pSelf, final ConnectorKind pKind, final IMatchProcessor<? super ConnectorKindMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pKind}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Connector pSelf, final ConnectorKind pKind, final IMatchProcessor<? super ConnectorKindMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pKind}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pKind the fixed value of pattern parameter kind, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ConnectorKindMatch newMatch(final Connector pSelf, final ConnectorKind pKind) {
    return ConnectorKindMatch.newMatch(pSelf, pKind);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Connector> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<Connector> results = new HashSet<Connector>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Connector> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Connector> getAllValuesOfself(final ConnectorKindMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Connector> getAllValuesOfself(final ConnectorKind pKind) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pKind
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for kind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ConnectorKind> rawAccumulateAllValuesOfkind(final Object[] parameters) {
    Set<ConnectorKind> results = new HashSet<ConnectorKind>();
    rawAccumulateAllValues(POSITION_KIND, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for kind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorKind> getAllValuesOfkind() {
    return rawAccumulateAllValuesOfkind(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for kind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorKind> getAllValuesOfkind(final ConnectorKindMatch partialMatch) {
    return rawAccumulateAllValuesOfkind(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for kind.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorKind> getAllValuesOfkind(final Connector pSelf) {
    return rawAccumulateAllValuesOfkind(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected ConnectorKindMatch tupleToMatch(final Tuple t) {
    try {
    	return ConnectorKindMatch.newMatch((Connector) t.get(POSITION_SELF), (ConnectorKind) t.get(POSITION_KIND));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ConnectorKindMatch arrayToMatch(final Object[] match) {
    try {
    	return ConnectorKindMatch.newMatch((Connector) match[POSITION_SELF], (ConnectorKind) match[POSITION_KIND]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ConnectorKindMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ConnectorKindMatch.newMutableMatch((Connector) match[POSITION_SELF], (ConnectorKind) match[POSITION_KIND]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ConnectorKindMatcher> querySpecification() throws IncQueryException {
    return ConnectorKindQuerySpecification.instance();
  }
}
