package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.NamespaceImportedMemberQuerySpecification;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.namespaceImportedMember pattern,
 * to be used in conjunction with {@link NamespaceImportedMemberMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see NamespaceImportedMemberMatcher
 * @see NamespaceImportedMemberProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class NamespaceImportedMemberMatch extends BasePatternMatch {
  private Namespace fNamespace;
  
  private PackageableElement fImportedMember;
  
  private static List<String> parameterNames = makeImmutableList("namespace", "importedMember");
  
  private NamespaceImportedMemberMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    this.fNamespace = pNamespace;
    this.fImportedMember = pImportedMember;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("namespace".equals(parameterName)) return this.fNamespace;
    if ("importedMember".equals(parameterName)) return this.fImportedMember;
    return null;
  }
  
  public Namespace getNamespace() {
    return this.fNamespace;
  }
  
  public PackageableElement getImportedMember() {
    return this.fImportedMember;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("namespace".equals(parameterName) ) {
    	this.fNamespace = (Namespace) newValue;
    	return true;
    }
    if ("importedMember".equals(parameterName) ) {
    	this.fImportedMember = (PackageableElement) newValue;
    	return true;
    }
    return false;
  }
  
  public void setNamespace(final Namespace pNamespace) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fNamespace = pNamespace;
  }
  
  public void setImportedMember(final PackageableElement pImportedMember) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fImportedMember = pImportedMember;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.namespaceImportedMember";
  }
  
  @Override
  public List<String> parameterNames() {
    return NamespaceImportedMemberMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fNamespace, fImportedMember};
  }
  
  @Override
  public NamespaceImportedMemberMatch toImmutable() {
    return isMutable() ? newMatch(fNamespace, fImportedMember) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"namespace\"=" + prettyPrintValue(fNamespace) + ", ");
    
    result.append("\"importedMember\"=" + prettyPrintValue(fImportedMember)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fNamespace == null) ? 0 : fNamespace.hashCode());
    result = prime * result + ((fImportedMember == null) ? 0 : fImportedMember.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof NamespaceImportedMemberMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    NamespaceImportedMemberMatch other = (NamespaceImportedMemberMatch) obj;
    if (fNamespace == null) {if (other.fNamespace != null) return false;}
    else if (!fNamespace.equals(other.fNamespace)) return false;
    if (fImportedMember == null) {if (other.fImportedMember != null) return false;}
    else if (!fImportedMember.equals(other.fImportedMember)) return false;
    return true;
  }
  
  @Override
  public NamespaceImportedMemberQuerySpecification specification() {
    try {
    	return NamespaceImportedMemberQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static NamespaceImportedMemberMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static NamespaceImportedMemberMatch newMutableMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return new Mutable(pNamespace, pImportedMember);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pNamespace the fixed value of pattern parameter namespace, or null if not bound.
   * @param pImportedMember the fixed value of pattern parameter importedMember, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static NamespaceImportedMemberMatch newMatch(final Namespace pNamespace, final PackageableElement pImportedMember) {
    return new Immutable(pNamespace, pImportedMember);
  }
  
  private static final class Mutable extends NamespaceImportedMemberMatch {
    Mutable(final Namespace pNamespace, final PackageableElement pImportedMember) {
      super(pNamespace, pImportedMember);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends NamespaceImportedMemberMatch {
    Immutable(final Namespace pNamespace, final PackageableElement pImportedMember) {
      super(pNamespace, pImportedMember);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
