package org.eclipse.incquery.viewers.runtime.model.patterns;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2containmentQuerySpecification;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.viewers.runtime.model.patterns.param2containment pattern,
 * to be used in conjunction with {@link Param2containmentMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see Param2containmentMatcher
 * @see Param2containmentProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class Param2containmentMatch extends BasePatternMatch {
  private Object fSource;
  
  private Object fTarget;
  
  private Trace fTrace;
  
  private Containment fContainment;
  
  private static List<String> parameterNames = makeImmutableList("source", "target", "trace", "containment");
  
  private Param2containmentMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment) {
    this.fSource = pSource;
    this.fTarget = pTarget;
    this.fTrace = pTrace;
    this.fContainment = pContainment;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("source".equals(parameterName)) return this.fSource;
    if ("target".equals(parameterName)) return this.fTarget;
    if ("trace".equals(parameterName)) return this.fTrace;
    if ("containment".equals(parameterName)) return this.fContainment;
    return null;
  }
  
  public Object getSource() {
    return this.fSource;
  }
  
  public Object getTarget() {
    return this.fTarget;
  }
  
  public Trace getTrace() {
    return this.fTrace;
  }
  
  public Containment getContainment() {
    return this.fContainment;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("source".equals(parameterName) && newValue instanceof java.lang.Object) {
    	this.fSource = (java.lang.Object) newValue;
    	return true;
    }
    if ("target".equals(parameterName) && newValue instanceof java.lang.Object) {
    	this.fTarget = (java.lang.Object) newValue;
    	return true;
    }
    if ("trace".equals(parameterName) ) {
    	this.fTrace = (org.eclipse.incquery.viewmodel.traceability.Trace) newValue;
    	return true;
    }
    if ("containment".equals(parameterName) ) {
    	this.fContainment = (org.eclipse.incquery.viewers.runtime.model.Containment) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSource(final Object pSource) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSource = pSource;
  }
  
  public void setTarget(final Object pTarget) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTarget = pTarget;
  }
  
  public void setTrace(final Trace pTrace) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fTrace = pTrace;
  }
  
  public void setContainment(final Containment pContainment) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fContainment = pContainment;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.viewers.runtime.model.patterns.param2containment";
  }
  
  @Override
  public List<String> parameterNames() {
    return Param2containmentMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSource, fTarget, fTrace, fContainment};
  }
  
  @Override
  public Param2containmentMatch toImmutable() {
    return isMutable() ? newMatch(fSource, fTarget, fTrace, fContainment) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"source\"=" + prettyPrintValue(fSource) + ", ");
    
    result.append("\"target\"=" + prettyPrintValue(fTarget) + ", ");
    
    result.append("\"trace\"=" + prettyPrintValue(fTrace) + ", ");
    
    result.append("\"containment\"=" + prettyPrintValue(fContainment)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSource == null) ? 0 : fSource.hashCode());
    result = prime * result + ((fTarget == null) ? 0 : fTarget.hashCode());
    result = prime * result + ((fTrace == null) ? 0 : fTrace.hashCode());
    result = prime * result + ((fContainment == null) ? 0 : fContainment.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof Param2containmentMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    Param2containmentMatch other = (Param2containmentMatch) obj;
    if (fSource == null) {if (other.fSource != null) return false;}
    else if (!fSource.equals(other.fSource)) return false;
    if (fTarget == null) {if (other.fTarget != null) return false;}
    else if (!fTarget.equals(other.fTarget)) return false;
    if (fTrace == null) {if (other.fTrace != null) return false;}
    else if (!fTrace.equals(other.fTrace)) return false;
    if (fContainment == null) {if (other.fContainment != null) return false;}
    else if (!fContainment.equals(other.fContainment)) return false;
    return true;
  }
  
  @Override
  public Param2containmentQuerySpecification specification() {
    try {
    	return Param2containmentQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static Param2containmentMatch newEmptyMatch() {
    return new Mutable(null, null, null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pContainment the fixed value of pattern parameter containment, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static Param2containmentMatch newMutableMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment) {
    return new Mutable(pSource, pTarget, pTrace, pContainment);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param pTrace the fixed value of pattern parameter trace, or null if not bound.
   * @param pContainment the fixed value of pattern parameter containment, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static Param2containmentMatch newMatch(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment) {
    return new Immutable(pSource, pTarget, pTrace, pContainment);
  }
  
  private static final class Mutable extends Param2containmentMatch {
    Mutable(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment) {
      super(pSource, pTarget, pTrace, pContainment);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends Param2containmentMatch {
    Immutable(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment) {
      super(pSource, pTarget, pTrace, pContainment);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
