package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.OperationReturnResultMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.OperationReturnResultQuerySpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.operationReturnResult pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link OperationReturnResultMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (memberEnd-{@literal >}reject(p | ownedEnd-{@literal >}includes(p.oclAsType(ExtensionEnd)))-{@literal >}any(true))
 * 
 * // Can't compile OCL to IncQuery because of java.lang.IllegalArgumentException: Iterator expression kind must be collect, select or reject instead of any in self.memberEnd-{@literal >}reject(p : Property | self.ownedEnd-{@literal >}includes(p.oclAsType(uml::ExtensionEnd)))-{@literal >}any(temp1 : Property | true)
 * //pattern extensionMetaclassEnd(source: Extension, target: Property) {}
 * 
 * 
 * (if (lowerValue=null or lowerValue.integerValue()=null) then 1 else lowerValue.integerValue() endif)
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: integerValue
 * //pattern multiplicityElementLowerBound(source: MultiplicityElement, target: Integer) {}
 * 
 * 
 * (if (upperValue=null or upperValue.unlimitedValue()=null) then 1 else upperValue.unlimitedValue() endif)
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: unlimitedValue
 * //pattern multiplicityElementUpperBound(source: MultiplicityElement, target: UnlimitedNatural) {}
 * 
 * 
 * (ownedParameter-{@literal >}select (direction = ParameterDirectionKind::return)-{@literal >}asSet())
 * 
 * {@literal @}QueryExplorer(checked = false)
 * pattern operationReturnResult(
 *     self : Operation,
 *     temp1 : Parameter
 * ) {
 *     Parameter.direction(temp1, parameterDirectionKind);
 *     parameterDirectionKind_0 == ParameterDirectionKind::^return;
 *     parameterDirectionKind == parameterDirectionKind_0;
 *     BehavioralFeature.ownedParameter(self, parameter);
 *     temp1 == parameter;
 * }
 * </pre></code>
 * 
 * @see OperationReturnResultMatch
 * @see OperationReturnResultProcessor
 * @see OperationReturnResultQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class OperationReturnResultMatcher extends BaseMatcher<OperationReturnResultMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static OperationReturnResultMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    OperationReturnResultMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new OperationReturnResultMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_TEMP1 = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(OperationReturnResultMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public OperationReturnResultMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public OperationReturnResultMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return matches represented as a OperationReturnResultMatch object.
   * 
   */
  public Collection<OperationReturnResultMatch> getAllMatches(final Operation pSelf, final Parameter pTemp1) {
    return rawGetAllMatches(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return a match represented as a OperationReturnResultMatch object, or null if no match is found.
   * 
   */
  public OperationReturnResultMatch getOneArbitraryMatch(final Operation pSelf, final Parameter pTemp1) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Operation pSelf, final Parameter pTemp1) {
    return rawHasMatch(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Operation pSelf, final Parameter pTemp1) {
    return rawCountMatches(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Operation pSelf, final Parameter pTemp1, final IMatchProcessor<? super OperationReturnResultMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pTemp1}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Operation pSelf, final Parameter pTemp1, final IMatchProcessor<? super OperationReturnResultMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pTemp1}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public OperationReturnResultMatch newMatch(final Operation pSelf, final Parameter pTemp1) {
    return OperationReturnResultMatch.newMatch(pSelf, pTemp1);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Operation> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<Operation> results = new HashSet<Operation>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Operation> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Operation> getAllValuesOfself(final OperationReturnResultMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Operation> getAllValuesOfself(final Parameter pTemp1) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pTemp1
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Parameter> rawAccumulateAllValuesOftemp1(final Object[] parameters) {
    Set<Parameter> results = new HashSet<Parameter>();
    rawAccumulateAllValues(POSITION_TEMP1, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Parameter> getAllValuesOftemp1() {
    return rawAccumulateAllValuesOftemp1(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Parameter> getAllValuesOftemp1(final OperationReturnResultMatch partialMatch) {
    return rawAccumulateAllValuesOftemp1(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Parameter> getAllValuesOftemp1(final Operation pSelf) {
    return rawAccumulateAllValuesOftemp1(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected OperationReturnResultMatch tupleToMatch(final Tuple t) {
    try {
    	return OperationReturnResultMatch.newMatch((org.eclipse.uml2.uml.Operation) t.get(POSITION_SELF), (org.eclipse.uml2.uml.Parameter) t.get(POSITION_TEMP1));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected OperationReturnResultMatch arrayToMatch(final Object[] match) {
    try {
    	return OperationReturnResultMatch.newMatch((org.eclipse.uml2.uml.Operation) match[POSITION_SELF], (org.eclipse.uml2.uml.Parameter) match[POSITION_TEMP1]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected OperationReturnResultMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return OperationReturnResultMatch.newMutableMatch((org.eclipse.uml2.uml.Operation) match[POSITION_SELF], (org.eclipse.uml2.uml.Parameter) match[POSITION_TEMP1]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<OperationReturnResultMatcher> querySpecification() throws IncQueryException {
    return OperationReturnResultQuerySpecification.instance();
  }
}
