package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.DeploymentTargetDeployedElementMatch;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.PackageableElement;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.deploymentTargetDeployedElement pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class DeploymentTargetDeployedElementProcessor implements IMatchProcessor<DeploymentTargetDeployedElementMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSelf the value of pattern parameter self in the currently processed match
   * @param pPackageableElement the value of pattern parameter packageableElement in the currently processed match
   * 
   */
  public abstract void process(final DeploymentTarget pSelf, final PackageableElement pPackageableElement);
  
  @Override
  public void process(final DeploymentTargetDeployedElementMatch match) {
    process(match.getSelf(), match.getPackageableElement());
  }
}
