/**
 * Copyright (c) 2010-2014, Abel Hegedus, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.incquery.querybasedfeatures.tooling;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.QueryBasedFeatures;
import org.eclipse.incquery.querybasedfeatures.tooling.QueryBasedFeatureGenerator;
import org.eclipse.incquery.querybasedfeatures.tooling.QueryBasedFeatureParameters;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class SettingDelegateBasedGenerator {
  @Extension
  private QueryBasedFeatureGenerator gen;
  
  public SettingDelegateBasedGenerator(final QueryBasedFeatureGenerator generator) {
    this.gen = generator;
  }
  
  protected void updateAnnotations(final Pattern pattern, final Annotation annotation, final boolean generate) {
    try {
      final QueryBasedFeatureParameters parameters = this.gen.processDerivedFeatureAnnotation(pattern, annotation, generate);
      if (generate) {
        this.updateEcorePackage(parameters);
        this.updateFeatureAnnotation(parameters);
      } else {
        this.removeFeatureAnnotation(parameters);
      }
      try {
        Resource _eResource = parameters.ePackage.eResource();
        _eResource.save(null);
      } catch (final Throwable _t) {
        if (_t instanceof IOException) {
          final IOException e = (IOException)_t;
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    } catch (final Throwable _t_1) {
      if (_t_1 instanceof IllegalArgumentException) {
        final IllegalArgumentException e_1 = (IllegalArgumentException)_t_1;
        if (generate) {
          String _message = e_1.getMessage();
          this.gen.logger.error(_message, e_1);
        }
      } else {
        throw Exceptions.sneakyThrow(_t_1);
      }
    }
  }
  
  private void updateEcorePackage(final QueryBasedFeatureParameters parameters) {
    try {
      final EPackage pckg = parameters.ePackage;
      EList<EAnnotation> _eAnnotations = pckg.getEAnnotations();
      final ArrayList<EAnnotation> annotations = new ArrayList<EAnnotation>(_eAnnotations);
      final Function1<EAnnotation, Boolean> _function = new Function1<EAnnotation, Boolean>() {
        @Override
        public Boolean apply(final EAnnotation it) {
          String _source = it.getSource();
          return Boolean.valueOf(Objects.equal(_source, QueryBasedFeatures.ECORE_ANNOTATION));
        }
      };
      EAnnotation ecoreAnnotation = IterableExtensions.<EAnnotation>findFirst(annotations, _function);
      boolean _equals = Objects.equal(ecoreAnnotation, null);
      if (_equals) {
        EAnnotation _createEAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        ecoreAnnotation = _createEAnnotation;
        ecoreAnnotation.setSource(QueryBasedFeatures.ECORE_ANNOTATION);
        EList<EAnnotation> _eAnnotations_1 = pckg.getEAnnotations();
        _eAnnotations_1.add(ecoreAnnotation);
      }
      EMap<String, String> _details = ecoreAnnotation.getDetails();
      final Function1<Map.Entry<String, String>, Boolean> _function_1 = new Function1<Map.Entry<String, String>, Boolean>() {
        @Override
        public Boolean apply(final Map.Entry<String, String> it) {
          String _key = it.getKey();
          return Boolean.valueOf(Objects.equal(_key, QueryBasedFeatures.SETTING_DELEGATES_KEY));
        }
      };
      Map.Entry<String, String> entry = IterableExtensions.<Map.Entry<String, String>>findFirst(_details, _function_1);
      boolean _equals_1 = Objects.equal(entry, null);
      if (_equals_1) {
        EMap<String, String> _details_1 = ecoreAnnotation.getDetails();
        _details_1.put(QueryBasedFeatures.SETTING_DELEGATES_KEY, QueryBasedFeatures.ANNOTATION_SOURCE);
      } else {
        String _value = entry.getValue();
        final StringTokenizer delegates = new StringTokenizer(_value);
        while (delegates.hasMoreTokens()) {
          {
            final String delegate = delegates.nextToken();
            boolean _equals_2 = Objects.equal(delegate, QueryBasedFeatures.ANNOTATION_SOURCE);
            if (_equals_2) {
              return;
            }
          }
        }
        String _value_1 = entry.getValue();
        String _plus = (_value_1 + " ");
        String _plus_1 = (_plus + QueryBasedFeatures.ANNOTATION_SOURCE);
        entry.setValue(_plus_1);
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        String _name = parameters.ePackage.getName();
        String _format = String.format("Error happened when trying to add QBF annotation to package %s in Ecore!", _name);
        this.gen.logger.warn(_format, e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  private String updateFeatureAnnotation(final QueryBasedFeatureParameters parameters) {
    String _xtrycatchfinallyexpression = null;
    try {
      String _xblockexpression = null;
      {
        final EStructuralFeature feat = parameters.feature;
        EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
        final ArrayList<EAnnotation> annotations = new ArrayList<EAnnotation>(_eAnnotations);
        final Procedure1<EAnnotation> _function = new Procedure1<EAnnotation>() {
          @Override
          public void apply(final EAnnotation it) {
            String _source = it.getSource();
            boolean _equals = Objects.equal(_source, QueryBasedFeatures.ANNOTATION_SOURCE);
            if (_equals) {
              EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
              _eAnnotations.remove(it);
            }
          }
        };
        IterableExtensions.<EAnnotation>forEach(annotations, _function);
        final EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QueryBasedFeatures.ANNOTATION_SOURCE);
        EList<EAnnotation> _eAnnotations_1 = feat.getEAnnotations();
        _eAnnotations_1.add(annotation);
        EMap<String, String> _details = annotation.getDetails();
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(parameters.pattern);
        _xblockexpression = _details.put(QueryBasedFeatures.PATTERN_FQN_KEY, _fullyQualifiedName);
      }
      _xtrycatchfinallyexpression = _xblockexpression;
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        String _name = parameters.feature.getName();
        String _format = String.format("Error happened when trying to add QBF annotation to feature %s in Ecore!", _name);
        this.gen.logger.warn(_format, e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return _xtrycatchfinallyexpression;
  }
  
  private void removeFeatureAnnotation(final QueryBasedFeatureParameters parameters) {
    try {
      final EStructuralFeature feat = parameters.feature;
      EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
      final ArrayList<EAnnotation> annotations = new ArrayList<EAnnotation>(_eAnnotations);
      final Procedure1<EAnnotation> _function = new Procedure1<EAnnotation>() {
        @Override
        public void apply(final EAnnotation it) {
          String _source = it.getSource();
          boolean _equals = Objects.equal(_source, QueryBasedFeatures.ANNOTATION_SOURCE);
          if (_equals) {
            EList<EAnnotation> _eAnnotations = feat.getEAnnotations();
            _eAnnotations.remove(it);
          }
        }
      };
      IterableExtensions.<EAnnotation>forEach(annotations, _function);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        String _format = String.format("Error happened when trying to remove annotation to feature %s in Ecore!", parameters.feature);
        this.gen.logger.warn(_format, e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
