/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventRealm;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;

public final class ObservableCollectionHelper {
    private ObservableCollectionHelper() {
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newSimpleMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT_NO_UPDATE, jobs);
    }

    public static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, Matcher matcher) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newSimpleMatcherRuleSpecification(matcher, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT_NO_UPDATE, jobs);
    }

    private static <Match extends IPatternMatch> Set<Job<Match>> getObservableCollectionJobs(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate) {
        Job insertJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate)));
        Job deleteJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate)));
        return ImmutableSet.of((Object)insertJob, (Object)deleteJob);
    }

    public static <Match extends IPatternMatch> void prepareRuleEngine(IncQueryEngine engine, RuleSpecification<Match> specification, Match filter) {
        ExecutionSchema ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        if (filter != null) {
            ruleEngine.addRule(specification, true, (EventFilter)IncQueryEventRealm.createFilter(filter));
        } else {
            ruleEngine.addRule(specification, true);
        }
    }
}

