/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred;

import java.util.Collections;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.helpers.BuildHelper;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.VariableDeferredPConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;

public abstract class PatternCallBasedDeferred<PatternDescription, StubHandle>
extends VariableDeferredPConstraint<PatternDescription, StubHandle> {
    protected Tuple actualParametersTuple;
    protected PatternDescription pattern;
    private Set<PVariable> deferringVariables;

    protected abstract void doDoReplaceVariables(PVariable var1, PVariable var2);

    protected abstract Set<PVariable> getCandidateQuantifiedVariables();

    public PatternCallBasedDeferred(PSystem<PatternDescription, StubHandle, ?> pSystem, Tuple actualParametersTuple, PatternDescription pattern, Set<PVariable> additionalAffectedVariables) {
        super(pSystem, PatternCallBasedDeferred.union(actualParametersTuple.getDistinctElements(), additionalAffectedVariables));
        this.actualParametersTuple = actualParametersTuple;
        this.pattern = pattern;
    }

    public PatternCallBasedDeferred(PSystem<PatternDescription, StubHandle, ?> pSystem, Tuple actualParametersTuple, PatternDescription pattern) {
        this(pSystem, actualParametersTuple, pattern, Collections.emptySet());
    }

    private static Set<PVariable> union(Set<PVariable> a, Set<PVariable> b) {
        Set<PVariable> result = CollectionsFactory.getSet();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    @Override
    protected Set<PVariable> getDeferringVariables() {
        if (this.deferringVariables == null) {
            this.deferringVariables = CollectionsFactory.getSet();
            for (PVariable var : this.getCandidateQuantifiedVariables()) {
                if (!var.isDeducable()) continue;
                this.deferringVariables.add(var);
            }
        }
        return this.deferringVariables;
    }

    @Override
    public void checkSanity() throws RetePatternBuildException {
        super.checkSanity();
        for (Object obj : this.actualParametersTuple.getDistinctElements()) {
            PVariable var = (PVariable)obj;
            if (this.getDeferringVariables().contains(var)) continue;
            for (PConstraint pConstraint : var.getReferringConstraints()) {
                if (pConstraint == this || pConstraint instanceof Equality && ((Equality)pConstraint).isMoot()) continue;
                throw new RetePatternBuildException("Variable {1} of constraint {2} is not a positively determined part of the pattern, yet it is also affected by {3}.", new String[]{var.toString(), this.toString(), pConstraint.toString()}, "Read-only variable can not be deduced", null);
            }
        }
    }

    protected BuildHelper.JoinHelper<StubHandle> getJoinHelper(Stub<StubHandle> stub, Stub<StubHandle> sideStub) {
        BuildHelper.JoinHelper<StubHandle> joinHelper = new BuildHelper.JoinHelper<StubHandle>(stub, sideStub);
        return joinHelper;
    }

    protected Stub<StubHandle> getSideStub() throws RetePatternBuildException {
        Stub sideStub = this.buildable.patternCallStub(this.actualParametersTuple, this.pattern);
        sideStub = BuildHelper.enforceVariableCoincidences(this.buildable, sideStub);
        return sideStub;
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.deferringVariables != null) {
            throw new IllegalStateException("Cannot replace variables on " + this + " when deferring variables have already been identified.");
        }
        this.actualParametersTuple.replaceAll(obsolete, replacement);
        this.doDoReplaceVariables(obsolete, replacement);
    }
}

