/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.matchers.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Node;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.Supplier;

public abstract class NullIndexer
extends SpecializedProjectionIndexer {
    static Object[] empty = new Object[0];
    static Tuple nullSignature = new FlatTuple(empty);
    static Collection<Tuple> nullSingleton = Collections.singleton(nullSignature);
    static Collection<Tuple> emptySet = Collections.emptySet();

    protected abstract Collection<Tuple> getTuples();

    public NullIndexer(ReteContainer reteContainer, int tupleWidth, Supplier parent, Node activeNode) {
        super(reteContainer, TupleMask.linear((int)0, (int)tupleWidth), parent, activeNode);
    }

    @Override
    public Collection<Tuple> get(Tuple signature) {
        if (nullSignature.equals((Object)signature)) {
            return this.isEmpty() ? null : this.getTuples();
        }
        return null;
    }

    @Override
    public Collection<Tuple> getSignatures() {
        return this.isEmpty() ? emptySet : nullSingleton;
    }

    protected boolean isEmpty() {
        return this.getTuples().isEmpty();
    }

    protected boolean isSingleElement() {
        return this.getTuples().size() == 1;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.getTuples().iterator();
    }

    public void propagate(Direction direction, Tuple updateElement) {
        boolean radical = direction == Direction.REVOKE && this.isEmpty() || direction == Direction.INSERT && this.isSingleElement();
        this.propagate(direction, updateElement, nullSignature, radical);
    }
}

