/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuildContext;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.impl.QueuedBuildData;
import org.eclipse.xtext.builder.impl.ToBeBuilt;
import org.eclipse.xtext.builder.impl.XtextBuilder;

public class IncQueryProjectBuilder
extends XtextBuilder {
    public static final String BUILDER_ID = "org.eclipse.incquery.tooling.core.projectbuilder";
    @Inject
    private IEiqGenmodelProvider genmodelProvider;
    @Inject
    private IXtextBuilderParticipant participant;
    @Inject
    private QueuedBuildData queuedBuildData;
    @Inject
    private IBuilderState builderState;

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ChangeDetector visitor = new ChangeDetector(this.genmodelProvider.getGeneratorModelPath(this.getProject()));
        delta.accept((IResourceDeltaVisitor)visitor);
        if (visitor.isChangeFound()) {
            super.fullBuild(monitor, false);
        } else {
            super.incrementalBuild(delta, monitor);
        }
    }

    protected void doBuild(ToBeBuilt toBeBuilt, IProgressMonitor monitor, IXtextBuilderParticipant.BuildType type) throws CoreException {
        BuildData buildData;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ResourceSet resourceSet = this.getResourceSetProvider().get(this.getProject());
        resourceSet.getLoadOptions().put("org.eclipse.xtext.scoping.namespaces.DefaultGlobalScopeProvider.BUILDER_SCOPE", Boolean.TRUE);
        if (resourceSet instanceof ResourceSetImpl) {
            ((ResourceSetImpl)resourceSet).setURIResourceMap((Map)Maps.newHashMap());
        }
        if (!(buildData = new BuildData(this.getProject().getName(), resourceSet, toBeBuilt, this.queuedBuildData)).isEmpty()) {
            ImmutableList deltas = this.builderState.update(buildData, (IProgressMonitor)progress.newChild(1));
            if (this.participant != null) {
                this.participant.build((IXtextBuilderParticipant.IBuildContext)new BuildContext((XtextBuilder)this, resourceSet, (List)deltas, type), (IProgressMonitor)progress.newChild(1));
                this.getProject().getWorkspace().checkpoint(false);
            } else {
                progress.worked(1);
            }
        } else {
            progress.worked(2);
        }
        resourceSet.eSetDeliver(false);
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    protected void doClean(ToBeBuilt toBeBuilt, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ImmutableList deltas = this.builderState.clean(toBeBuilt.getToBeDeleted(), (IProgressMonitor)progress.newChild(1));
        if (this.participant != null) {
            this.participant.build((IXtextBuilderParticipant.IBuildContext)new BuildContext((XtextBuilder)this, this.getResourceSetProvider().get(this.getProject()), (List)deltas, IXtextBuilderParticipant.BuildType.CLEAN), (IProgressMonitor)progress.newChild(1));
        } else {
            progress.worked(1);
        }
    }

    private static final class ChangeDetector
    implements IResourceDeltaVisitor {
        private final IPath path;
        private boolean changeFound = false;

        public ChangeDetector(IPath path) {
            this.path = path;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.path.equals((Object)delta.getFullPath())) {
                this.changeFound = true;
            }
            return !this.changeFound;
        }

        public boolean isChangeFound() {
            return this.changeFound;
        }
    }
}

