/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import com.google.common.base.Function;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchCollectionBuilder;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchList;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.CompositeContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.MatchComparator;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.TransformerFunction;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;

public class PatternMatcherContent
extends CompositeContent<PatternMatcherRootContent, PatternMatchContent> {
    private static final String KEY_ATTRIBUTE_OF_ORDER_BY_ANNOTATION = "The key attribute of OrderBy annotation must look like \"ClassName.AttributeName\"!";
    private final boolean generated;
    private IPatternMatch filter;
    private Object[] parameterFilter;
    private String orderParameter;
    private boolean ascendingOrder;
    private String exceptionMessage;
    private Exception exception;
    private IQuerySpecification<?> specification;
    private IncQueryMatcher<IPatternMatch> matcher;
    private ObservablePatternMatchList<IPatternMatch> children;
    private TransformerFunction transformerFunction;
    private MatchComparator matchComparator;
    private IListChangeListener listChangeListener;

    public PatternMatcherContent(PatternMatcherRootContent parent, IncQueryEngine engine, RuleEngine ruleEngine, IQuerySpecification<?> specification, boolean generated) {
        super(parent);
        this.specification = specification;
        this.transformerFunction = new TransformerFunction(this);
        this.listChangeListener = new ListChangeListener();
        if (specification.getInternalQueryRepresentation().getStatus() != PQuery.PQueryStatus.ERROR) {
            try {
                this.matcher = engine.getMatcher(specification);
            }
            catch (IncQueryException e) {
                this.exceptionMessage = e.getShortMessage();
                this.exception = e;
                this.logException();
            }
            catch (Exception e) {
                this.exceptionMessage = e.getMessage();
                this.exception = e;
                this.logException();
            }
        }
        this.generated = generated;
        this.orderParameter = null;
        DisplayUtil.removeOrderByPatternWarning(specification.getFullyQualifiedName());
        if (this.matcher != null) {
            this.initOrdering();
            this.initFilter();
            ObservablePatternMatchCollectionBuilder builder = ObservablePatternMatchCollectionBuilder.create(specification);
            builder.setComparator((Comparator)this.matchComparator).setConverter((Function)this.transformerFunction).setFilter(this.filter);
            this.children = builder.setEngine(ruleEngine).buildList();
            this.children.addListChangeListener(this.listChangeListener);
            this.setText(DisplayUtil.getMessage(this.matcher, this.children.size(), specification.getFullyQualifiedName(), this.isGenerated(), this.isFiltered(), this.exceptionMessage));
        } else {
            this.setText(DisplayUtil.getMessage(null, 0, specification.getFullyQualifiedName(), this.isGenerated(), this.isFiltered(), this.exceptionMessage));
        }
    }

    private void logException() {
        String logMessage = String.format("Query Explorer has encountered an error during evaluation of query %s%s", this.specification.getFullyQualifiedName(), this.exceptionMessage == null ? "" : ": " + this.exceptionMessage);
        IncQueryGUIPlugin.getDefault().getLog().log((IStatus)new Status(4, IncQueryGUIPlugin.getDefault().getBundle().getSymbolicName(), logMessage, (Throwable)this.exception));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.matcher = null;
        this.specification = null;
        if (this.children != null) {
            this.children.removeListChangeListener(this.listChangeListener);
        }
        this.listChangeListener = null;
    }

    private void initOrdering() {
        PAnnotation annotation = this.specification.getFirstAnnotationByName("OrderBy");
        if (annotation != null) {
            for (Map.Entry ap : annotation.getAllValues()) {
                if (((String)ap.getKey()).matches("key")) {
                    this.orderParameter = (String)ap.getValue();
                }
                if (!((String)ap.getKey()).matches("direction")) continue;
                String direction = (String)ap.getValue();
                this.ascendingOrder = direction.matches("asc");
            }
            if (this.orderParameter != null) {
                String[] tokens = this.orderParameter.split("\\.");
                if (tokens.length != 2) {
                    DisplayUtil.addOrderByPatternWarning(this.matcher.getPatternName(), KEY_ATTRIBUTE_OF_ORDER_BY_ANNOTATION);
                } else {
                    this.matchComparator = new MatchComparator(this.matcher, tokens[0], tokens[1], this.ascendingOrder);
                }
            }
        }
    }

    public IQuerySpecification<?> getSpecification() {
        return this.specification;
    }

    public IncQueryMatcher<IPatternMatch> getMatcher() {
        return this.matcher;
    }

    public String getPatternName() {
        return this.specification.getFullyQualifiedName();
    }

    private void initFilter() {
        if (this.matcher != null) {
            int arity = this.matcher.getParameterNames().size();
            this.parameterFilter = new Object[arity];
            this.filter = this.matcher.newMatch(this.parameterFilter);
        }
    }

    public void setFilter(Object[] parameterFilter) {
        this.parameterFilter = (Object[])parameterFilter.clone();
        this.filter = this.matcher.newMatch(this.parameterFilter);
        this.children.setFilter(this.filter);
    }

    private boolean isFiltered() {
        if (this.matcher != null) {
            int i = 0;
            while (i < this.matcher.getParameterNames().size()) {
                if (this.parameterFilter[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object[] getFilter() {
        return this.parameterFilter;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isCreated() {
        return this.specification.getInternalQueryRepresentation().getStatus() == PQuery.PQueryStatus.OK && this.matcher != null;
    }

    @Override
    public IObservableList getChildren() {
        return this.children;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public Iterator<PatternMatchContent> getChildrenIterator() {
        return this.children.iterator();
    }

    private class ListChangeListener
    implements IListChangeListener {
        private ListChangeListener() {
        }

        public void handleListChange(ListChangeEvent event) {
            ListDiffEntry[] listDiffEntryArray = event.diff.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry entry = listDiffEntryArray[n2];
                if (!entry.isAddition()) {
                    ((PatternMatchContent)entry.getElement()).dispose();
                } else {
                    ((PatternMatchContent)entry.getElement()).initialize();
                }
                ++n2;
            }
            PatternMatcherContent.this.setText(DisplayUtil.getMessage((IncQueryMatcher<? extends IPatternMatch>)PatternMatcherContent.this.matcher, PatternMatcherContent.this.children.size(), PatternMatcherContent.this.specification.getFullyQualifiedName(), PatternMatcherContent.this.isGenerated(), PatternMatcherContent.this.isFiltered(), PatternMatcherContent.this.exceptionMessage));
            PatternMatcherContent.this.updateHasChildren();
        }
    }
}

