/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.ParameterReference;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.converters.FixedComputedSet;
import org.eclipse.incquery.viewers.runtime.model.converters.FormatParser;

public class EdgeSet
extends FixedComputedSet {
    private String labelParameterName;
    private String sourceParameterName;
    private String destParameterName;
    private Multimap<Object, Item> itemMap;
    private FormatSpecification format;
    private IObservableSet patternMatchSet;

    public EdgeSet(PAnnotation itemAnnotation, PAnnotation formatAnnotation, Multimap<Object, Item> itemMap, IObservableSet patternMatchSet) {
        Preconditions.checkArgument((boolean)"Edge".equals(itemAnnotation.getName()), (Object)"The converter should be initialized using a Edge annotation.");
        this.itemMap = itemMap;
        this.sourceParameterName = ((ParameterReference)itemAnnotation.getFirstValue("source")).getName();
        this.destParameterName = ((ParameterReference)itemAnnotation.getFirstValue("target")).getName();
        Object labelParam = itemAnnotation.getFirstValue("label");
        String string = this.labelParameterName = labelParam == null ? "" : (String)labelParam;
        if (formatAnnotation != null) {
            this.format = FormatParser.parseFormatAnnotation(formatAnnotation);
        }
        this.patternMatchSet = patternMatchSet;
    }

    @Override
    protected Set<Edge> calculate() {
        HashSet<Edge> edgeSet = new HashSet<Edge>();
        for (Object _match : this.patternMatchSet) {
            IPatternMatch match = (IPatternMatch)_match;
            EObject sourceValue = (EObject)match.get(this.sourceParameterName);
            EObject destValue = (EObject)match.get(this.destParameterName);
            for (Object _sourceItem : this.itemMap.get((Object)sourceValue)) {
                Item sourceItem = (Item)_sourceItem;
                for (Object _destItem : this.itemMap.get((Object)destValue)) {
                    Item destItem = (Item)_destItem;
                    Edge edge = new Edge(sourceItem, destItem, match, this.labelParameterName);
                    edge.setSpecification(this.format);
                    edgeSet.add(edge);
                }
            }
        }
        return edgeSet;
    }
}

