/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.NotationFactory;
import org.eclipse.incquery.viewers.runtime.model.NotationModel;
import org.eclipse.incquery.viewmodel.core.ViewModelManager;

public abstract class ViewerDataModel {
    private final String NOTATION_RESOURCE = "org.eclipse.incquery.viewers.notation.NotationResource";
    protected NotationModel model;
    protected IncQueryEngine engine;

    public ViewerDataModel(ResourceSet notifier) throws IncQueryException, IncQueryBaseException {
        this(IncQueryEngine.on((IncQueryScope)new EMFScope((Notifier)notifier)));
    }

    public ViewerDataModel(IncQueryEngine engine) throws IncQueryException, IncQueryBaseException {
        if (!(engine.getScope() instanceof EMFScope)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for IncQueryEngine");
            return;
        }
        this.model = NotationFactory.eINSTANCE.createNotationModel();
        this.engine = engine;
        this.prepareBaseNotifier();
    }

    private void prepareBaseNotifier() throws IncQueryException, IncQueryBaseException {
        Collection<? extends Notifier> notifiers = this.getNotifiers();
        Resource resource = null;
        block0: for (Notifier notifier : notifiers) {
            Resource r;
            if (notifier instanceof Resource && this.checkNotationResource(r = (Resource)notifier)) {
                resource = r;
                break;
            }
            if (!(notifier instanceof ResourceSet)) continue;
            ResourceSet resourceSet = (ResourceSet)notifier;
            for (Resource r2 : resourceSet.getResources()) {
                if (!this.checkNotationResource(r2)) continue;
                resource = r2;
                continue block0;
            }
        }
        if (resource == null) {
            resource = this.addNotationResource();
        }
        resource.getContents().add((Object)this.model);
    }

    private String getNotationResourceId() {
        return "org.eclipse.incquery.viewers.notation.NotationResource";
    }

    public NotationModel getNotationModel() {
        return this.model;
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public void dispose() {
        EcoreUtil.delete((EObject)this.model);
    }

    public abstract Collection<IQuerySpecification<?>> getPatterns();

    private Resource addNotationResource() throws IncQueryException, IncQueryBaseException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)this.getNotationResourceId()));
        NavigationHelper helper = EMFScope.extractUnderlyingEMFIndex((IncQueryEngine)this.engine);
        helper.addRoot((Notifier)resourceSet);
        return resource;
    }

    private boolean checkNotationResource(Resource r) {
        return r.getURI().toString().equals(this.getNotationResourceId());
    }

    private Collection<? extends Notifier> getNotifiers() {
        return ((EMFScope)this.engine.getScope()).getScopeRoots();
    }
}

