/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime.handler;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.incquery.querybasedfeatures.runtime.handler.IterationQueryBasedFeature;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class SumQueryBasedFeature
extends IterationQueryBasedFeature {
    private final Map<InternalEObject, Integer> counterMemory = new HashMap<InternalEObject, Integer>();
    private final boolean countOnly;

    protected SumQueryBasedFeature(EStructuralFeature feature, QueryBasedFeatureKind kind) {
        super(feature, false);
        if (!(feature instanceof EAttribute)) {
            IncQueryLoggingUtil.getDefaultLogger().error((Object)"[IncqueryFeatureHandler] Invalid configuration (Aggregate can be used only with EAttribute)!");
        }
        this.countOnly = QueryBasedFeatureKind.COUNTER.equals((Object)kind);
    }

    @Override
    protected ENotificationImpl newMatchIteration(IPatternMatch signature) {
        InternalEObject source = this.getSourceValue(signature);
        Integer oldValue = this.getIntValue(source);
        Integer delta = (Integer)this.getTargetValue(signature);
        if (delta == null && this.countOnly) {
            delta = 1;
        }
        if (delta != null && oldValue <= Integer.MAX_VALUE - delta) {
            int tempMemory = oldValue + delta;
            this.counterMemory.put(source, tempMemory);
            return new ENotificationImpl(source, 1, this.getFeature(), (Object)this.getIntValue(source), (Object)tempMemory);
        }
        this.engineForMatcher().getLogger().error((Object)String.format("[IncqueryFeatureHandler] Exception during update: The counter of %s for feature %s reached the maximum value of int!", source, this.getFeature()));
        return null;
    }

    @Override
    protected ENotificationImpl lostMatchIteration(IPatternMatch signature) {
        Integer value;
        InternalEObject source = this.getSourceValue(signature);
        Integer delta = (Integer)this.getTargetValue(signature);
        if (delta == null && this.countOnly) {
            delta = -1;
        }
        if ((value = this.counterMemory.get(source)) == null) {
            this.engineForMatcher().getLogger().error((Object)"[IncqueryFeatureHandler] Space-time continuum breached (should never happen): decreasing a counter with no previous value");
        } else {
            if (value >= delta) {
                int tempMemory = value - delta;
                int oldValue = value;
                this.counterMemory.put(source, tempMemory);
                return new ENotificationImpl(source, 1, this.getFeature(), (Object)oldValue, (Object)tempMemory);
            }
            this.engineForMatcher().getLogger().error((Object)String.format("[IncqueryFeatureHandler] Exception during update: The counter of %s for feature %s cannot go below zero!", source, this.getFeature()));
        }
        return null;
    }

    @Override
    public Object getValueIteration(Object source) {
        return this.getIntValue(source);
    }

    public int getIntValue(Object source) {
        Integer result = this.counterMemory.get(source);
        if (result == null) {
            result = 0;
        }
        return result;
    }

    @Override
    public QueryBasedFeatureKind getKind() {
        return this.countOnly ? QueryBasedFeatureKind.COUNTER : QueryBasedFeatureKind.SUM;
    }

    @Override
    public Object getValue(Object source) {
        return null;
    }
}

