/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class Validator {
    private Validator() {
    }

    public static void ensureNotNull(Object o) throws LDAPSDKUsageException {
        if (o == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(0, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNullWithMessage(Object o, String message) throws LDAPSDKUsageException {
        if (o == null) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(Object o1, Object o2) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null) {
            int index = o1 == null ? 0 : 1;
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(Object o1, Object o2, Object o3) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : 2);
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(Object o1, Object o2, Object o3, Object o4) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null || o4 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : (o3 == null ? 2 : 3));
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureNotNull(Object o1, Object o2, Object o3, Object o4, Object o5) throws LDAPSDKUsageException {
        if (o1 == null || o2 == null || o3 == null || o4 == null || o5 == null) {
            int index = o1 == null ? 0 : (o2 == null ? 1 : (o3 == null ? 2 : (o4 == null ? 3 : 4)));
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_NULL_CHECK_FAILURE.get(index, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureTrue(boolean condition) throws LDAPSDKUsageException {
        if (!condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_TRUE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureTrue(boolean condition, String message) throws LDAPSDKUsageException {
        if (!condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureFalse(boolean condition) throws LDAPSDKUsageException {
        if (condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FALSE_CHECK_FAILURE.get(StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }

    public static void ensureFalse(boolean condition, String message) throws LDAPSDKUsageException {
        if (condition) {
            LDAPSDKUsageException e = new LDAPSDKUsageException(UtilityMessages.ERR_VALIDATOR_FAILURE_CUSTOM_MESSAGE.get(message, StaticUtils.getStackTrace(Thread.currentThread().getStackTrace())));
            Debug.debugCodingError(e);
            throw e;
        }
    }
}

