/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.ArchiveInfo;
import com.sun.ant.taskdefs.common.CompatValidator;
import com.sun.ant.taskdefs.common.SunRITool;
import com.sun.ant.taskdefs.common.TaskUtil;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class CompatHelper
extends Task {
    private String javaversion;
    private String riversion;
    private static String validationMsg;
    private static boolean isCompatBuild;
    private String cleanpkgdirs;
    private String javaInUse;
    private String riInUse;
    private String checkin;
    private String checkout;
    private String comment = "update";

    public void setJavaversion(String s) {
        this.javaversion = s;
    }

    public void setRiversion(String s) {
        this.riversion = s;
    }

    public void setCheckin(String s) {
        this.checkin = s;
    }

    public void setCheckout(String s) {
        this.checkout = s;
    }

    public static boolean isCompatBuild() {
        return isCompatBuild;
    }

    public static void copyArchivesToSrc(File distDir, File srcDir, Project project) {
        boolean noValidationMsg;
        Copy copy;
        FileSet fs;
        boolean noClass;
        if (!isCompatBuild) {
            return;
        }
        if (distDir == null || srcDir == null || srcDir.compareTo(distDir) == 0) {
            return;
        }
        File[] archiveFiles = distDir.listFiles(ArchiveInfo.rarJarWarEarFilter);
        File classDir = new File(project.getProperty("class.dir"), project.getProperty("pkg.dir"));
        File[] classFiles = classDir.listFiles(ArchiveInfo.classFilter);
        boolean noArchive = archiveFiles == null || archiveFiles.length == 0;
        boolean bl = noClass = classFiles == null || classFiles.length == 0;
        if (noArchive && noClass) {
            return;
        }
        String includePattern = "";
        if (!noArchive) {
            for (int i = 0; i < archiveFiles.length; ++i) {
                includePattern = includePattern + archiveFiles[i].getName() + ",";
            }
            if (includePattern.endsWith(",")) {
                includePattern = includePattern.substring(0, includePattern.length() - 1);
            }
            fs = new FileSet();
            fs.setDir(distDir);
            fs.setIncludes(includePattern);
            copy = new Copy();
            copy.setProject(project);
            copy.init();
            copy.setTaskName("Copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            copy.addFileset(fs);
            copy.perform();
            includePattern = "";
        }
        if (!noClass) {
            for (int i = 0; i < classFiles.length; ++i) {
                includePattern = includePattern + classFiles[i].getName() + ",";
            }
            if (includePattern.endsWith(",")) {
                includePattern = includePattern.substring(0, includePattern.length() - 1);
            }
            fs = new FileSet();
            fs.setDir(classDir);
            fs.setIncludes(includePattern);
            copy = new Copy();
            copy.setProject(project);
            copy.init();
            copy.setTaskName("Copy");
            copy.setTodir(srcDir);
            copy.setOverwrite(true);
            copy.addFileset(fs);
            copy.perform();
            includePattern = "";
        }
        project.log("####################### IMPORTANT #############################");
        if (noArchive) {
            project.log("No archive has been generated.");
        } else {
            project.log(archiveFiles.length + " archives have been generated in both src and dist dirs:");
            for (int i = 0; i < archiveFiles.length; ++i) {
                project.log(archiveFiles[i].getName());
            }
        }
        archiveFiles = null;
        project.log("---------------------------------------------------------------");
        if (noClass) {
            project.log("No class has been compiled.");
        } else {
            project.log(classFiles.length + " classes have been compiled into src and class dirs:");
            for (int i = 0; i < classFiles.length; ++i) {
                project.log(classFiles[i].getName());
            }
        }
        project.log("--------------------------- TODO ------------------------------");
        project.log("1 reset JAVA_HOME and j2ee.home.ri");
        project.log("2 tsant build runclient");
        project.log("3 sccs delget archive and class files");
        project.log("---------------------------------------------------------------");
        project.log("To avoid repeatedly editing ts.jte or build.properties:");
        project.log("  set j2ee.home.ri=${env.J2EE_HOME_RI} in ts.jte or build.properties, and");
        project.log("  switch J2EE_HOME_RI in shell between different versions");
        String finding = CompatHelper.searchInSrcDir(project);
        boolean noFinding = finding == null || finding.length() == 0;
        boolean bl2 = noValidationMsg = validationMsg == null || validationMsg.length() == 0;
        if (!noFinding || !noValidationMsg) {
            project.log("---------------------------------------------------------------");
            if (!noFinding) {
                project.log(finding);
            }
            if (!noValidationMsg) {
                project.log(validationMsg);
            }
        }
        project.log("###############################################################");
    }

    private void doCheckin() {
        File baseDir = this.project.getBaseDir();
        StringTokenizer st = new StringTokenizer(this.checkin, " ,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File f = new File(baseDir, token);
            if (new File(baseDir, "SCCS/p." + token).exists()) {
                TaskUtil.sccsDelget(this.project, f, this.comment);
                continue;
            }
            if (new File(baseDir, "SCCS/s." + token).exists()) continue;
            this.log("File " + token + " does not exist in sccs, will create.");
            TaskUtil.sccsCreate(this.project, f);
        }
    }

    private void doCheckout() {
        File baseDir = this.project.getBaseDir();
        StringTokenizer st = new StringTokenizer(this.checkin, " ,");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            File f = new File(baseDir, token);
            TaskUtil.sccsEdit(this.project, f);
        }
    }

    private String retrieveRiversion() {
        String j2eeHomeRi = TSBuildListener.j2eeHomeRi;
        if (j2eeHomeRi == null || j2eeHomeRi.length() == 0) {
            throw new BuildException("Please set j2ee.home.ri in bin/ts.jte or build.properties to a " + this.riversion + " installation");
        }
        while (j2eeHomeRi.endsWith("/") || j2eeHomeRi.endsWith("\\")) {
            j2eeHomeRi = j2eeHomeRi.substring(0, j2eeHomeRi.length() - 1);
        }
        ExecTask cmd = new ExecTask();
        cmd.setProject(this.project);
        cmd.init();
        cmd.setTaskName("riversion");
        cmd.setFailonerror(true);
        String exeline = null;
        exeline = j2eeHomeRi.endsWith("/") ? j2eeHomeRi + "bin/j2ee" : (j2eeHomeRi.endsWith("\\") ? j2eeHomeRi + "bin\\j2ee" : (j2eeHomeRi.indexOf("\\") != -1 ? j2eeHomeRi + "\\bin\\j2ee" : j2eeHomeRi + "/bin/j2ee"));
        Commandline.Argument arg = cmd.createArg();
        arg.setLine("-version");
        cmd.setExecutable(exeline);
        cmd.setVMLauncher(true);
        cmd.setOutputproperty("j2ee.ri.version");
        cmd.setTimeout(new Integer(300000));
        try {
            cmd.perform();
        }
        catch (BuildException ex) {
            ex.printStackTrace();
            this.log("Mostly likely your J2EE_HOME_RI is not pointing to the right version.");
            throw new BuildException(ex.getMessage());
        }
        String vstr = this.project.getProperty("j2ee.ri.version");
        String result = null;
        if (vstr != null) {
            int pos = (vstr = vstr.toLowerCase()).indexOf("version");
            if (pos != -1) {
                result = vstr.substring(pos + 7).trim();
            } else {
                this.log("Output does not contain 'version' (case-insensitive)");
            }
        } else {
            this.log("Got null from running j2ee -version.");
        }
        return result;
    }

    private void resetDtds() {
        if (this.riversion.startsWith("1.2")) {
            SunRITool.PUBLICID_APP_CLIENT = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
            SunRITool.PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
            SunRITool.PUBLICID_WEB = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
            SunRITool.DEFAULT_SUNRI13_APP_CLIENT_DTD_LOCATION = "application-client_1_2.dtd";
            SunRITool.DEFAULT_SUNRI13_EJB20_DTD_LOCATION = "ejb-jar_1_1.dtd";
            SunRITool.DEFAULT_SUNRI13_WEB_DTD_LOCATION = "web-app_2_2.dtd";
        } else if (this.riversion.startsWith("1.3")) {
            SunRITool.PUBLICID_EJB20 = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
            SunRITool.PUBLICID_APP_CLIENT = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
            SunRITool.PUBLICID_WEB = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
            SunRITool.DEFAULT_SUNRI13_EJB20_DTD_LOCATION = "ejb-jar_2_0.dtd";
            SunRITool.DEFAULT_SUNRI13_APP_CLIENT_DTD_LOCATION = "application-client_1_3.dtd";
            SunRITool.DEFAULT_SUNRI13_WEB_DTD_LOCATION = "web-app_2_3.dtd";
        }
    }

    public void setCleanpkgdirs(String s) {
        this.cleanpkgdirs = s;
    }

    private void cleanOne(String pkgDir) {
        String classDir = this.project.getProperty("class.dir");
        File dir1 = new File(classDir);
        FileSet fs1 = new FileSet();
        fs1.setDir(dir1);
        File dir2 = new File(this.project.getProperty("dist.dir"), pkgDir);
        FileSet fs2 = new FileSet();
        fs2.setDir(dir2);
        Delete del = new Delete();
        del.setProject(this.project);
        del.init();
        del.setTaskName(this.getTaskName());
        del.setFailOnError(false);
        del.setIncludeEmptyDirs(false);
        del.addFileset(fs1);
        del.perform();
        del = new Delete();
        del.setProject(this.project);
        del.init();
        del.setTaskName(this.getTaskName());
        del.setFailOnError(false);
        del.setIncludeEmptyDirs(false);
        del.addFileset(fs2);
        del.perform();
        dir1.mkdirs();
    }

    private void cleanup() {
        String pkgDir = this.project.getProperty("pkg.dir");
        int pos1 = (pkgDir = pkgDir.replace('\\', '/')).indexOf("/tests/");
        if (pos1 == -1) {
            throw new BuildException("pkg.dir does not contain '/tests/':" + pkgDir);
        }
        int pos2 = pkgDir.indexOf("/", pos1 + 7);
        if (pos2 == -1) {
            this.cleanOne(pkgDir);
        } else {
            this.cleanOne(pkgDir.substring(0, pos2));
        }
        if (this.cleanpkgdirs != null) {
            StringTokenizer st = new StringTokenizer(this.cleanpkgdirs, " ,\n\r\f\t");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.cleanOne(token);
            }
        }
    }

    public void execute() throws BuildException {
        if (this.javaversion == null || this.javaversion.length() == 0 || this.riversion == null || this.riversion.length() == 0) {
            throw new BuildException("Please specify javaversion and riversion that should be used to build.");
        }
        this.javaversion = this.javaversion.trim();
        if (!this.javaversion.equals("1.2") && !this.javaversion.equals("1.3")) {
            throw new BuildException("Invalid javaversion:" + this.javaversion + ". Choose 1.2 or 1.3");
        }
        if (!this.riversion.equals("1.2") && !this.riversion.equals("1.3")) {
            throw new BuildException("Invalid riversion:" + this.riversion + ". Choose 1.2 or 1.3");
        }
        this.javaInUse = this.project.getProperty("java.version");
        if (!this.javaInUse.startsWith(this.javaversion)) {
            throw new BuildException("Current java.version is " + this.javaInUse + ". Please setenv JAVA_HOME to a JDK" + this.javaversion + " installation.");
        }
        this.project.log("####################### IMPORTANT #############################");
        this.project.log("java version = " + this.javaInUse);
        this.riInUse = this.retrieveRiversion();
        if (!this.riInUse.startsWith(this.riversion)) {
            throw new BuildException("Current RI version is " + this.riInUse + ". Please set j2ee.home.ri in bin/ts.jte or build.properties to a j2ee " + this.riversion + " installation.");
        }
        this.project.log("ri   version = " + this.riInUse);
        CompatValidator va = new CompatValidator();
        va.validate(this.project.getProperty("ant.file"));
        validationMsg = va.getMsg();
        if (validationMsg.length() > 0) {
            this.project.log("---------------------------------------------------------------");
            this.project.log(validationMsg);
        }
        this.project.log("---------------------------------------------------------------");
        this.project.log("Make sure you've sccs-edited archives & classes to be built.");
        this.project.log("###############################################################");
        this.resetDtds();
        this.cleanup();
        isCompatBuild = true;
    }

    private static String searchInSrcDir(Project project) {
        int archiveFilesNum2;
        File srcDir = project.getBaseDir();
        File sccsDir = new File(srcDir, "SCCS");
        if (!sccsDir.exists()) {
            return "WARN: SCCS dir does not exist!";
        }
        String result = "";
        File[] classFiles2 = sccsDir.listFiles(ArchiveInfo.classFilter);
        int classFilesNum2 = classFiles2 == null ? 0 : classFiles2.length;
        File[] archiveFiles2 = sccsDir.listFiles(ArchiveInfo.rarJarWarEarFilter);
        int n = archiveFilesNum2 = archiveFiles2 == null ? 0 : archiveFiles2.length;
        if (archiveFilesNum2 == 0) {
            result = result + "WARN: no archive file was found under SCCS\n";
        }
        if (classFilesNum2 == 0) {
            result = result + "WARN: no class file was found under SCCS";
        }
        return result;
    }
}

