/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd.controller.intern;

import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.eclipse.jubula.client.cmd.controller.IClcServer;

public class RmiClient {
    private int m_portNumber;
    private Registry m_registry;
    private IClcServer m_clcService;

    public RmiClient(int portNumber) {
        this.m_portNumber = portNumber;
        try {
            this.m_registry = LocateRegistry.getRegistry(this.m_portNumber);
            this.findServices();
        }
        catch (RemoteException e) {
            throw new IllegalArgumentException("Can't connect to RMI registry on port " + this.m_portNumber, e);
        }
        catch (NotBoundException e) {
            throw new IllegalStateException("Can't bind service", e);
        }
    }

    private void findServices() throws RemoteException, NotBoundException {
        this.m_clcService = (IClcServer)this.m_registry.lookup("ClcService");
        assert (this.m_clcService != null);
    }

    public IClcServer getService() {
        return this.m_clcService;
    }
}

