/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.helpers.app.editors.properties.method;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNameLabelProvider
implements ILabelProvider {
    private List<IMethod> methods;
    Map<String, Integer> currentIds = new HashMap<String, Integer>();

    public MethodNameLabelProvider(List<IMethod> methods) {
        this.methods = methods;
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        int index = this.getMethodId(element);
        IMethod method = this.methods.get(index);
        try {
            return Signature.toString((String)method.getSignature(), (String)method.getElementName(), (String[])method.getParameterNames(), (boolean)false, (boolean)true);
        }
        catch (JavaModelException javaModelException) {
            return method.getElementName();
        }
    }

    private int getMethodId(Object element) {
        if (!this.currentIds.containsKey((String)element)) {
            this.currentIds.put((String)element, 0);
        }
        int previousInstances = this.currentIds.get((String)element);
        int i = 0;
        while (!(i >= this.methods.size() || element.equals(this.methods.get(i).getElementName()) && previousInstances == 0)) {
            if (element.equals(this.methods.get(i).getElementName())) {
                --previousInstances;
            }
            ++i;
        }
        this.currentIds.put((String)element, this.currentIds.get((String)element) + 1);
        return i;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

