/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

public class Tag {
    private int tag;
    private byte tagclass;
    private boolean constructed;
    public static final byte UNIVERSAL = 0;
    public static final byte APPLICATION = 1;
    public static final byte CONTEXT = 2;
    public static final byte PRIVATE = 3;
    public static final boolean PRIMITIVE = false;
    public static final boolean CONSTRUCTED = true;

    public Tag() {
        this.tag = 0;
        this.tagclass = 0;
        this.constructed = false;
    }

    public Tag(Tag t) {
        this.tag = t.tag;
        this.tagclass = t.tagclass;
        this.constructed = t.constructed;
    }

    public Tag(int tag, byte tagClass, boolean constructed) {
        this.tag = tag;
        this.tagclass = tagClass;
        this.constructed = constructed;
    }

    public Tag(byte[] binary, int[] offset) {
        this.fromBinary(binary, offset);
    }

    public Tag(byte[] binary) {
        int[] offset = new int[]{0};
        this.fromBinary(binary, offset);
    }

    public int size() {
        if (this.tag < 31) {
            return 1;
        }
        if (this.tag < 128) {
            return 2;
        }
        if (this.tag < 16384) {
            return 3;
        }
        if (this.tag < 0x200000) {
            return 4;
        }
        return 5;
    }

    public final void fromBinary(byte[] binary, int[] offset) {
        this.tagclass = (byte)((binary[offset[0]] & 0xC0) >>> 6);
        this.constructed = (binary[offset[0]] & 0x20) == 32;
        this.tag = 0;
        if ((binary[offset[0]] & 0x1F) == 31) {
            do {
                offset[0] = offset[0] + 1;
                this.tag *= 128;
                this.tag += binary[offset[0]] & 0x7F;
            } while ((binary[offset[0]] & 0x80) == 128);
        } else {
            this.tag = binary[offset[0]] & 0x1F;
        }
        offset[0] = offset[0] + 1;
    }

    public byte[] getBytes() {
        int[] offset = new int[]{0};
        byte[] result = new byte[this.size()];
        this.toBinary(result, offset);
        return result;
    }

    public void toBinary(byte[] binary, int[] offset) {
        byte[] classes = new byte[]{0, 64, -128, -64};
        int n = offset[0];
        binary[n] = (byte)(binary[n] | classes[this.tagclass]);
        if (this.constructed) {
            int n2 = offset[0];
            binary[n2] = (byte)(binary[n2] | 0x20);
        }
        if (this.tag < 31) {
            int n3 = offset[0];
            binary[n3] = (byte)(binary[n3] | (byte)this.tag);
        } else {
            int n4 = offset[0];
            binary[n4] = (byte)(binary[n4] | 0x1F);
            for (int count = this.size() - 2; count > 0; --count) {
                offset[0] = offset[0] + 1;
                binary[offset[0]] = (byte)(0x80 | this.tag >> count * 7 & 0x7F);
            }
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.tag & 0x7F);
        }
        offset[0] = offset[0] + 1;
    }

    public void set(int tag, byte tagclass, boolean constructed) {
        this.tag = tag;
        this.tagclass = tagclass;
        this.constructed = constructed;
    }

    public void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    public int code() {
        return this.tag;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public int hashCode() {
        return this.tag + this.tagclass;
    }

    public boolean equals(Object o) {
        return this.tag == ((Tag)o).tag && this.tagclass == ((Tag)o).tagclass;
    }

    public String toString() {
        return "(" + this.tag + "," + this.tagclass + "," + this.constructed + ")";
    }
}

