/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Observable<T> {
    private boolean changed = false;
    private final Object SYNC = new Object();
    private Set<Observer<T>> observers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer<T> observer) {
        if (observer == null) {
            return;
        }
        Object object = this.SYNC;
        synchronized (object) {
            if (this.observers == null) {
                this.observers = new HashSet<Observer<T>>(1);
            }
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Observer<T> observer) {
        if (observer == null) {
            return;
        }
        Object object = this.SYNC;
        synchronized (object) {
            if (this.observers != null) {
                this.observers.remove(observer);
            }
        }
    }

    public void clearObservers() {
        if (this.observers != null) {
            this.observers.clear();
        }
    }

    public void setChanged() {
        this.changed = true;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public int countObservers() {
        return this.observers == null ? 0 : this.observers.size();
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(T event) {
        HashSet<Observer<T>> observersCopy;
        Iterator iterator = this.SYNC;
        synchronized (iterator) {
            if (this.observers == null) {
                return;
            }
            observersCopy = new HashSet<Observer<T>>(this.observers);
        }
        for (Observer observer : observersCopy) {
            observer.update(event);
        }
    }

    public static interface Observer<T> {
        public void update(T var1);
    }
}

