/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.remotese.rm;

import org.eclipse.keyple.plugin.remotese.exception.KeypleRemoteException;
import org.eclipse.keyple.plugin.remotese.rm.RemoteMethodTx;
import org.eclipse.keyple.plugin.remotese.transport.DtoHandler;
import org.eclipse.keyple.plugin.remotese.transport.DtoSender;
import org.eclipse.keyple.plugin.remotese.transport.KeypleDtoHelper;
import org.eclipse.keyple.plugin.remotese.transport.model.KeypleDto;
import org.eclipse.keyple.plugin.remotese.transport.model.TransportDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMethodTxEngine
implements DtoHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteMethodTxEngine.class);
    private RemoteMethodTx remoteMethodTx;
    private final DtoSender sender;

    public RemoteMethodTxEngine(DtoSender sender) {
        this.sender = sender;
    }

    @Override
    public TransportDto onDTO(TransportDto message) {
        KeypleDto keypleDto = message.getKeypleDTO();
        if (message.getKeypleDTO().isRequest().booleanValue()) {
            throw new IllegalArgumentException("RemoteMethodTxEngine expects a KeypleDto response. " + message.getKeypleDTO());
        }
        if (this.remoteMethodTx == null) {
            throw new IllegalStateException("RemoteMethodTxEngine receives a KeypleDto response but no remoteMethodTx are defined : " + message.getKeypleDTO());
        }
        this.remoteMethodTx.asyncSetResponse(keypleDto);
        this.remoteMethodTx = null;
        return message.nextTransportDTO(KeypleDtoHelper.NoResponse());
    }

    public void register(RemoteMethodTx rm) throws KeypleRemoteException {
        logger.debug("Register rm to engine : {}", (Object)rm);
        this.remoteMethodTx = rm;
        rm.setDto(this.sender);
    }
}

