/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.editors;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.linuxtools.internal.changelog.core.editors.FileHyperlink;
import org.eclipse.linuxtools.internal.changelog.core.editors.GNUHyperlinkScanner;

public class GNUHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IPath documentLocation;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (this.documentLocation == null) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer(textViewer.getDocument());
            if (buffer == null) {
                return null;
            }
            IPath p = buffer.getLocation();
            if (p == null) {
                return null;
            }
            this.documentLocation = p.removeLastSegments(1);
        }
        IDocument thisDoc = textViewer.getDocument();
        GNUHyperlinkScanner scanner = new GNUHyperlinkScanner();
        ITypedRegion partitionInfo = null;
        try {
            partitionInfo = thisDoc.getPartition(region.getOffset());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return null;
        }
        scanner.setRange(thisDoc, partitionInfo.getOffset(), partitionInfo.getLength());
        Token tmpToken = (Token)scanner.nextToken();
        String tokenStr = (String)tmpToken.getData();
        if (tokenStr == null) {
            return null;
        }
        while (region.getOffset() < scanner.getTokenOffset() || region.getOffset() > scanner.getOffset() || tokenStr.equals("_other")) {
            tmpToken = (Token)scanner.nextToken();
            tokenStr = (String)tmpToken.getData();
            if (tokenStr != null) continue;
            return null;
        }
        Region tokenRegion = new Region(scanner.getTokenOffset(), scanner.getTokenLength());
        String line = "";
        try {
            line = thisDoc.get(tokenRegion.getOffset(), tokenRegion.getLength());
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
            return null;
        }
        if (tokenStr.equals("_file_name")) {
            Region pathRegion = null;
            int lineOffset = 0;
            if (line.startsWith("* ")) {
                lineOffset = 2;
                line = line.substring(2);
            }
            pathRegion = new Region(tokenRegion.getOffset() + lineOffset, line.length());
            if (this.documentLocation == null) {
                return null;
            }
            line = line.replaceAll("\\\\(.)", "$1");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember(this.documentLocation.append(line));
            IFile fileLoc = (IFile)resource.getAdapter(IFile.class);
            if (fileLoc != null && fileLoc.exists()) {
                return new IHyperlink[]{new FileHyperlink((IRegion)pathRegion, fileLoc)};
            }
        }
        return null;
    }
}

