/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.client.messages.RootFs;

final class ImmutableRootFs
implements RootFs {
    private final String type;
    private final List<String> layers;

    private ImmutableRootFs(String type, List<String> layers) {
        this.type = type;
        this.layers = layers;
    }

    @Override
    @JsonProperty(value="Type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="Layers")
    public List<String> layers() {
        return this.layers;
    }

    public final ImmutableRootFs withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableRootFs(newValue, this.layers);
    }

    public final ImmutableRootFs withLayers(String ... elements) {
        List<String> newValue = ImmutableRootFs.createUnmodifiableList(false, ImmutableRootFs.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableRootFs(this.type, newValue);
    }

    public final ImmutableRootFs withLayers(Iterable<String> elements) {
        if (this.layers == elements) {
            return this;
        }
        List<String> newValue = ImmutableRootFs.createUnmodifiableList(false, ImmutableRootFs.createSafeList(elements, true, false));
        return new ImmutableRootFs(this.type, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRootFs && this.equalTo(0, (ImmutableRootFs)another);
    }

    private boolean equalTo(int synthetic, ImmutableRootFs another) {
        return this.type.equals(another.type) && this.layers.equals(another.layers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.layers.hashCode();
        return h;
    }

    public String toString() {
        return "RootFs{type=" + this.type + ", layers=" + String.valueOf(this.layers) + "}";
    }

    public static ImmutableRootFs copyOf(RootFs instance) {
        if (instance instanceof ImmutableRootFs) {
            return (ImmutableRootFs)instance;
        }
        return ImmutableRootFs.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        private String type;
        private List<String> layers = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(RootFs instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.addAllLayers(instance.layers());
            return this;
        }

        @JsonProperty(value="Type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder layer(String element) {
            this.layers.add(Objects.requireNonNull(element, "layers element"));
            return this;
        }

        public final Builder layers(String ... elements) {
            for (String element : elements) {
                this.layers.add(Objects.requireNonNull(element, "layers element"));
            }
            return this;
        }

        @JsonProperty(value="Layers")
        public final Builder layers(Iterable<String> elements) {
            this.layers.clear();
            return this.addAllLayers(elements);
        }

        public final Builder addAllLayers(Iterable<String> elements) {
            for (String element : elements) {
                this.layers.add(Objects.requireNonNull(element, "layers element"));
            }
            return this;
        }

        public ImmutableRootFs build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRootFs(this.type, ImmutableRootFs.createUnmodifiableList(true, this.layers));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build RootFs, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

