/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.folding;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class LSPFoldingReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IProjectionListener,
ITextViewerLifecycle {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final Pattern LICENSE_KEYWORDS = Pattern.compile("(?i)(copyright|licensed under|all rights reserved|SPDX-License-Identifier)");
    private @Nullable IDocument document;
    private @Nullable ProjectionAnnotationModel projectionAnnotationModel;
    private @Nullable ProjectionViewer viewer;
    private List<CompletableFuture<@Nullable List<FoldingRange>>> requests = List.of();
    private volatile long timestamp = 0L;
    private final IPreferenceStore prefStore = LanguageServerPlugin.getDefault().getPreferenceStore();
    private boolean isFoldingEnabled = this.prefStore.getBoolean("foldingReconcilingStrategy.enabled");
    private boolean collapseComments = this.prefStore.getBoolean("foldingReconcilingStrategy.collapseComments");
    private boolean collapseLicenseHeader = this.prefStore.getBoolean("foldingReconcilingStrategy.collapseLicenseHeaders");
    private boolean collapseFoldingRegions = this.prefStore.getBoolean("foldingReconcilingStrategy.collapseRegions");
    private boolean collapseImports = this.prefStore.getBoolean("foldingReconcilingStrategy.collapseImports");
    private final IPropertyChangeListener foldingPrefsListener = event -> {
        block20: {
            Object newValue = event.getNewValue();
            if (newValue == null) break block20;
            switch (event.getProperty()) {
                case "foldingReconcilingStrategy.enabled": {
                    this.isFoldingEnabled = Boolean.parseBoolean(newValue.toString());
                    if (this.isFoldingEnabled) {
                        this.reconcile(null);
                        break;
                    }
                    this.applyFolding(null);
                    break;
                }
                case "foldingReconcilingStrategy.collapseComments": {
                    this.collapseComments = Boolean.parseBoolean(newValue.toString());
                    break;
                }
                case "foldingReconcilingStrategy.collapseLicenseHeaders": {
                    this.collapseLicenseHeader = Boolean.parseBoolean(newValue.toString());
                    break;
                }
                case "foldingReconcilingStrategy.collapseRegions": {
                    this.collapseFoldingRegions = Boolean.parseBoolean(newValue.toString());
                    break;
                }
                case "foldingReconcilingStrategy.collapseImports": {
                    this.collapseImports = Boolean.parseBoolean(newValue.toString());
                }
            }
        }
    };

    public void reconcile(@Nullable IRegion subRegion) {
        IDocument document = this.document;
        if (!this.isFoldingEnabled || this.projectionAnnotationModel == null || document == null) {
            return;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return;
        }
        TextDocumentIdentifier identifier = LSPEclipseUtils.toTextDocumentIdentifier(uri);
        FoldingRangeRequestParams params = new FoldingRangeRequestParams(identifier);
        this.requests.forEach(request -> {
            boolean bl = request.cancel(true);
        });
        this.requests = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getFoldingRangeProvider)).computeAll(server -> server.getTextDocumentService().foldingRange(params));
        this.requests.forEach(ranges -> {
            CompletionStage completionStage = ranges.thenAccept(this::applyFolding);
        });
    }

    private void applyFolding(@Nullable List<FoldingRange> ranges) {
        ProjectionAnnotationModel theProjectionAnnotationModel;
        ArrayList<FoldingAnnotation> deletions = new ArrayList<FoldingAnnotation>();
        HashMap<Position, FoldingAnnotation> existing = new HashMap<Position, FoldingAnnotation>();
        HashMap additions = new HashMap();
        this.markInvalidAnnotationsForDeletion(deletions, existing);
        if (ranges != null) {
            boolean[] isFirstFoldingRange = new boolean[]{true};
            ranges.stream().sorted(Comparator.comparing(FoldingRange::getEndLine)).forEach(arg_0 -> this.lambda$7(isFirstFoldingRange, deletions, existing, additions, arg_0));
        }
        if ((theProjectionAnnotationModel = this.projectionAnnotationModel) != null) {
            if (!existing.isEmpty()) {
                deletions.addAll(existing.values());
            }
            theProjectionAnnotationModel.modifyAnnotations((Annotation[])deletions.toArray(Annotation[]::new), additions, NO_ANNOTATIONS);
        }
    }

    private String getTextOfFoldingRange(FoldingRange range) {
        IDocument doc = this.document;
        if (doc != null) {
            try {
                int offsetStart = doc.getLineOffset(range.getStartLine());
                return doc.get(offsetStart, doc.getLineOffset(range.getEndLine()) + doc.getLineLength(range.getEndLine()) - offsetStart);
            }
            catch (BadLocationException ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        return "";
    }

    public void install(ITextViewer viewer) {
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
        }
        if (viewer instanceof ProjectionViewer) {
            ProjectionViewer projViewer;
            this.viewer = projViewer = (ProjectionViewer)viewer;
            projViewer.addProjectionListener((IProjectionListener)this);
            this.projectionAnnotationModel = projViewer.getProjectionAnnotationModel();
            this.prefStore.addPropertyChangeListener(this.foldingPrefsListener);
        }
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.viewer != null) {
            this.viewer.removeProjectionListener((IProjectionListener)this);
            this.viewer = null;
            this.prefStore.removePropertyChangeListener(this.foldingPrefsListener);
        }
        this.projectionDisabled();
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void projectionDisabled() {
        this.projectionAnnotationModel = null;
    }

    public void projectionEnabled() {
        ProjectionViewer theViewer = this.viewer;
        if (theViewer != null) {
            this.projectionAnnotationModel = theViewer.getProjectionAnnotationModel();
        }
    }

    private void updateAnnotation(List<FoldingAnnotation> deletions, Map<Position, FoldingAnnotation> existing, Map<Annotation, Position> additions, int line, Integer endLineNumber, boolean collapsedByDefault) throws BadLocationException {
        int endOffset;
        IDocument document = NullSafetyHelper.castNonNull(this.document);
        int startOffset = document.getLineOffset(line);
        Position newPos = new Position(startOffset, (endOffset = document.getLineOffset(endLineNumber.intValue()) + document.getLineLength(endLineNumber.intValue())) - startOffset);
        FoldingAnnotation existingAnnotation = existing.remove(newPos);
        if (existingAnnotation == null) {
            additions.put((Annotation)new FoldingAnnotation(collapsedByDefault), newPos);
        }
    }

    private void markInvalidAnnotationsForDeletion(List<FoldingAnnotation> deletions, Map<Position, FoldingAnnotation> existing) {
        ProjectionAnnotationModel projectionAnnotationModel = this.projectionAnnotationModel;
        if (projectionAnnotationModel == null) {
            return;
        }
        Iterator iter = projectionAnnotationModel.getAnnotationIterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object e = iter.next();
                if (!(e instanceof FoldingAnnotation)) continue;
                FoldingAnnotation foldingAnno = (FoldingAnnotation)((Object)e);
                Position pos = projectionAnnotationModel.getPosition((Annotation)foldingAnno);
                if (pos.length == 0) {
                    deletions.add(foldingAnno);
                    continue;
                }
                FoldingAnnotation duplicate = existing.put(pos, foldingAnno);
                if (duplicate == null) continue;
                deletions.add(duplicate);
            }
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion partition) {
        long ts = DocumentUtil.getDocumentModificationStamp(this.document);
        if (ts != this.timestamp) {
            this.reconcile((IRegion)dirtyRegion);
            this.timestamp = ts;
        }
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        this.reconcile(null);
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$7(boolean[] var1_1, ArrayList var2_2, HashMap var3_3, HashMap var4_4, FoldingRange foldingRange) {
        try {
            if (foldingRange.getKind() == null) ** GOTO lbl-1000
            var7_6 = foldingRange.getKind();
            tmp = -1;
            switch (var7_6.hashCode()) {
                case -934795532: {
                    if (var7_6.equals("region")) {
                        tmp = 1;
                    }
                    break;
                }
                case 950398559: {
                    if (var7_6.equals("comment")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1926037870: {
                    if (var7_6.equals("imports")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 2: {
                    if (var1_1[0] && LSPFoldingReconcilingStrategy.LICENSE_KEYWORDS.matcher(this.getTextOfFoldingRange(foldingRange)).find()) {
                        if (!this.collapseLicenseHeader && !this.collapseComments) {
                            v0 = false;
                            break;
                        }
                        v0 = true;
                        break;
                    }
                    v0 = this.collapseComments;
                    break;
                }
                case 3: {
                    v0 = this.collapseImports;
                    break;
                }
                case 1: {
                    v0 = this.collapseFoldingRegions;
                    break;
                }
                default: {
                    v0 = false;
                }
            }
            if (v0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            collapsByDefault = v1;
            this.updateAnnotation(var2_2, var3_3, var4_4, foldingRange.getStartLine(), foldingRange.getEndLine(), collapsByDefault);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError(ex);
        }
        var1_1[0] = false;
    }

    protected class FoldingAnnotation
    extends ProjectionAnnotation {
        private boolean visible;

        public FoldingAnnotation(boolean isCollapsed) {
            super(isCollapsed);
            this.visible = false;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && rectangle.height / (metrics = gc.getFontMetrics()).getHeight() <= 1) {
                this.visible = false;
                return;
            }
            this.visible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.visible) {
                super.markCollapsed();
            }
        }
    }
}

