/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;

public abstract class DockerImageHierarchyNode
implements IDockerImageHierarchyNode {
    private IDockerImageHierarchyNode parent;
    private List<IDockerImageHierarchyNode> children = new ArrayList<IDockerImageHierarchyNode>();

    public DockerImageHierarchyNode(IDockerImageHierarchyNode parentImageHiearchyNode) {
        this.parent = parentImageHiearchyNode;
        if (this.parent != null) {
            this.parent.getChildren().add(this);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public IDockerImageHierarchyNode getParent() {
        return this.parent;
    }

    @Override
    public List<IDockerImageHierarchyNode> getChildren() {
        return this.children;
    }

    @Override
    public IDockerImageHierarchyNode getChild(String id) {
        return this.children.stream().filter(n -> {
            if (n.getElement() instanceof IDockerImage) {
                return ((IDockerImage)n.getElement()).id().equals(id);
            }
            return ((IDockerContainer)n.getElement()).id().equals(id);
        }).findFirst().orElse(null);
    }

    @Override
    public IDockerImageHierarchyNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public String toString() {
        return this.getElement().toString();
    }
}

