/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.actions;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.core.util.CDAModelUtil;
import org.eclipse.mdht.uml.cda.core.util.InstanceGenerator;
import org.eclipse.mdht.uml.cda.ui.internal.Logger;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class AddPublicationSample
implements IObjectActionDelegate {
    protected IWorkbenchPart activePart;
    Class clinicalDocument = null;

    public void run(IAction action) {
        try {
            final Package topPackage = UMLUtil.getTopPackage((Element)this.clinicalDocument);
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)topPackage);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Create New Sample"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    String documentSampleArtifact = String.format("%sSample", AddPublicationSample.this.clinicalDocument.getName());
                    String documentSampleArtifactFileName = String.format("%s.xml", documentSampleArtifact);
                    Type type = topPackage.getOwnedType(documentSampleArtifact);
                    Artifact artifact = null;
                    artifact = type != null && type instanceof Artifact ? (Artifact)type : (Artifact)topPackage.createOwnedType(String.valueOf(AddPublicationSample.this.clinicalDocument.getName()) + "Sample", UMLPackage.eINSTANCE.getArtifact());
                    artifact.setFileName(documentSampleArtifactFileName);
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IProject docProject = root.getProject(topPackage.eResource().getURI().segment(1).replace(".model", ".doc"));
                    if (docProject.exists()) {
                        IFile samplesFile;
                        IFolder samplesFolder = docProject.getFolder("samples");
                        if (!samplesFolder.exists()) {
                            try {
                                samplesFolder.create(false, true, null);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!(samplesFile = samplesFolder.getFile(documentSampleArtifactFileName)).exists()) {
                            try {
                                InstanceGenerator ig = new InstanceGenerator();
                                EObject instance = ig.createInstance(AddPublicationSample.this.clinicalDocument, 50);
                                FileOutputStream out = new FileOutputStream(root.getLocation().append(samplesFile.getFullPath()).toFile());
                                CDAUtil.save((ClinicalDocument)((ClinicalDocument)instance), (OutputStream)out);
                                docProject.refreshLocal(2, null);
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            if (selected instanceof IAdaptable) {
                selected = ((IAdaptable)selected).getAdapter(EObject.class);
            }
            if (selected instanceof Type && CDAModelUtil.isClinicalDocument((Type)((Type)selected))) {
                action.setEnabled(true);
                this.clinicalDocument = (Class)selected;
                this.clinicalDocument.eResource();
                return;
            }
        }
        action.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

