/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.util;

import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.term.ui.notation.TermPropertyNotation;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class CDAAssociationNotation {
    public static String getCustomLabel(Association association, int style) {
        String hl7Metadata;
        boolean showBrackets;
        StringBuffer buffer = new StringBuffer();
        if ((style & 2) != 0) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)association));
        }
        if ((style & 8) != 0) {
            buffer.append(" ");
            buffer.append(association.getName());
        }
        boolean bl = showBrackets = buffer.length() > 0;
        if ((style & 0x80) != 0) {
            boolean multiLine = (style & 0x100000) != 0;
            String modifiers = CDAAssociationNotation.getModifiersAsString(association, style);
            if (modifiers != null && !modifiers.equals("")) {
                if (multiLine) {
                    buffer.append("\n");
                }
                buffer.append(showBrackets ? " {" : "");
                buffer.append(modifiers);
                buffer.append(showBrackets ? "}" : "");
            }
        }
        if ((hl7Metadata = CDAAssociationNotation.getHL7Metadata(association, style)).length() > 0) {
            buffer.append(showBrackets ? " {" : "");
            buffer.append(hl7Metadata);
            buffer.append(showBrackets ? "}" : "");
        }
        return buffer.toString();
    }

    protected static String getModifiersAsString(Association association, int style) {
        String annotation = null;
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        if (navigableEnd != null) {
            annotation = TermPropertyNotation.getTerminologyAnnotations((Property)navigableEnd, (int)style);
        }
        return annotation;
    }

    private static String getHL7Metadata(Association association, int style) {
        String vocab;
        StringBuffer buffer = new StringBuffer();
        if ((style & 0x200) != 0 && (vocab = CDAAssociationNotation.getVocabulary(association)) != null && vocab.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(vocab);
        }
        return buffer.toString();
    }

    private static String getVocabulary(Association association) {
        StringBuffer value = new StringBuffer();
        Stereotype entry = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"Entry");
        Stereotype entryRelationship = CDAProfileUtil.getAppliedCDAStereotype((Element)association, (String)"EntryRelationship");
        try {
            if (entry != null) {
                Object literal = association.getValue(entry, "typeCode");
                String typeCode = null;
                if (literal instanceof EnumerationLiteral) {
                    typeCode = ((EnumerationLiteral)literal).getLabel();
                } else if (literal instanceof Enumerator) {
                    typeCode = ((Enumerator)literal).getName();
                    Enumeration entryKind = (Enumeration)entry.getProfile().getOwnedType("EntryKind");
                    if (entryKind != null) {
                        typeCode = entryKind.getOwnedLiteral(typeCode).getLabel();
                    }
                }
                if (typeCode != null) {
                    value.append(typeCode);
                }
            } else if (entryRelationship != null) {
                Object literal = association.getValue(entryRelationship, "typeCode");
                String typeCode = null;
                if (literal instanceof EnumerationLiteral) {
                    typeCode = ((EnumerationLiteral)literal).getLabel();
                } else if (literal instanceof Enumerator) {
                    typeCode = ((Enumerator)literal).getName();
                    Enumeration entryRelKind = (Enumeration)entryRelationship.getProfile().getOwnedType("EntryRelationshipKind");
                    if (entryRelKind != null) {
                        typeCode = entryRelKind.getOwnedLiteral(typeCode).getLabel();
                    }
                }
                if (typeCode != null) {
                    value.append(typeCode);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return value.toString();
    }
}

