/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.dita.ui.handlers;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.uml.common.util.CompareResultVisitor;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DitaCompare
implements CompareResultVisitor {
    StringBuilder buffer = new StringBuilder();
    IProgressMonitor monitor;

    private static String getEscapedElementName(NamedElement ne) {
        return StringEscapeUtils.escapeHtml((String)ne.getName());
    }

    public DitaCompare(String version1, String version2, IProgressMonitor monitor) {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.buffer.append("<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\" [ ");
        this.buffer.append("<!ENTITY rsquo \"&#160;\"> ");
        this.buffer.append("<!ENTITY ldquo \"&#160;\"> ");
        this.buffer.append("<!ENTITY rdquo \"&#160;\"> ");
        this.buffer.append("<!ENTITY ndash \"&#160;\"> ");
        this.buffer.append("<!ENTITY lsquo \"&#160;\"> ");
        this.buffer.append("]>");
        this.buffer.append("<topic id=\"modelupdates\" xml:lang=\"en-us\">");
        this.buffer.append("<title id=\"title\">Model Updates</title>");
        this.buffer.append("<shortdesc>Model Updates</shortdesc>");
        this.buffer.append("<body id=\"modelupdatesbody\" >");
        this.buffer.append("<section id=\"modelupdatesdescription\" >");
        this.buffer.append("<title>Model Updates</title>");
        this.buffer.append("<table colsep=\"1\" rowsep=\"1\"> <tgroup cols=\"2\"> <colspec colname=\"col1\" colwidth=\"2*\"/> <colspec colname=\"col2\" colwidth=\"1*\"/> <colspec colname=\"col3\" colwidth=\"1*\"/> <colspec colname=\"col4\" colwidth=\"2*\"/><thead><row><entry namest=\"col1\" nameend =\"col2\" valign=\"top\">Intial Version " + version1 + "</entry><entry namest=\"col3\" nameend =\"col4\" valign=\"top\">Target Version " + version2 + "</entry></row>" + "<row><entry colname=\"col1\" valign=\"top\">Domain</entry><entry colname=\"col2\" valign=\"top\">Class</entry><entry colname=\"col3\" valign=\"top\">Action</entry><entry colname=\"col4\" valign=\"top\">Element</entry></row>" + "</thead><tbody>").append(System.getProperty("line.separator"));
        this.monitor = monitor;
    }

    public void startElement(NamedElement element) {
        if (this.monitor != null) {
            this.monitor.subTask("Comparing " + element.getName());
            this.monitor.worked(1);
        }
    }

    public void addedElement(NamedElement owner, Element element) {
        if (owner instanceof Package && element instanceof Class) {
            DeltaDisplay.DELTADISPLAY.leftElement = null;
            this.buffer.append("<row><entry>" + StringEscapeUtils.escapeHtml((String)owner.getNearestPackage().getQualifiedName()) + "</entry><entry>" + (String)ElementDisplay.ELEMENTDISPLAYINSTANCE.doSwitch((EObject)element) + "</entry><entry>Added</entry><entry></entry></row>").append(System.getProperty("line.separator"));
        } else if (owner instanceof Class) {
            DeltaDisplay.DELTADISPLAY.leftElement = null;
            this.buffer.append("<row><entry>" + StringEscapeUtils.escapeHtml((String)owner.getNearestPackage().getQualifiedName()) + "</entry><entry>" + (String)ElementDisplay.ELEMENTDISPLAYINSTANCE.doSwitch((EObject)owner) + "</entry><entry>Added</entry><entry>" + (String)DeltaDisplay.DELTADISPLAY.doSwitch((EObject)element) + "</entry></row>").append(System.getProperty("line.separator"));
        }
    }

    public void deletedElement(NamedElement owner, Element element) {
        if (owner instanceof Package && element instanceof Class) {
            DeltaDisplay.DELTADISPLAY.leftElement = null;
            this.buffer.append("<row><entry>" + StringEscapeUtils.escapeHtml((String)owner.getNearestPackage().getQualifiedName()) + "</entry><entry>" + (String)ElementDisplay.ELEMENTDISPLAYINSTANCE.doSwitch((EObject)element) + "</entry><entry>Deleted</entry><entry></entry></row>").append(System.getProperty("line.separator"));
        } else if (owner instanceof Class) {
            DeltaDisplay.DELTADISPLAY.leftElement = null;
            this.buffer.append("<row><entry>" + StringEscapeUtils.escapeHtml((String)owner.getNearestPackage().getQualifiedName()) + "</entry><entry>" + (String)ElementDisplay.ELEMENTDISPLAYINSTANCE.doSwitch((EObject)owner) + "</entry><entry>Deleted</entry><entry>" + (String)DeltaDisplay.DELTADISPLAY.doSwitch((EObject)element) + "</entry></row>").append(System.getProperty("line.separator"));
        }
    }

    public void changedElement(NamedElement owner, Element origialElement, Element upatedElement) {
        if (owner instanceof Class) {
            DeltaDisplay.DELTADISPLAY.leftElement = origialElement;
            this.buffer.append("<row><entry>" + StringEscapeUtils.escapeHtml((String)owner.getNearestPackage().getQualifiedName()) + "</entry><entry>" + (String)ElementDisplay.ELEMENTDISPLAYINSTANCE.doSwitch((EObject)owner) + "</entry><entry>Updated</entry><entry>" + (String)DeltaDisplay.DELTADISPLAY.doSwitch((EObject)upatedElement) + "</entry></row>").append(System.getProperty("line.separator"));
        }
    }

    String getResults() {
        this.buffer.append("</tbody></tgroup></table>");
        this.buffer.append("</section>");
        this.buffer.append("</body>");
        this.buffer.append("</topic>").append(System.getProperty("line.separator"));
        return this.buffer.toString();
    }

    public void endElement(NamedElement element) {
    }

    static class DeltaDisplay
    extends UMLSwitch<String> {
        static final DeltaDisplay DELTADISPLAY = new DeltaDisplay();
        public Element leftElement;

        DeltaDisplay() {
        }

        public String caseComment(Comment comment) {
            return "Comment : " + StringEscapeUtils.escapeHtml((String)comment.getBody());
        }

        public String caseProperty(Property object) {
            StringBuilder sb = new StringBuilder();
            sb.append((String)Display.DISPLAYINSTANCE.doSwitch((EObject)object));
            if (this.leftElement != null) {
                sb.append(" to ").append((String)Display.DISPLAYINSTANCE.doSwitch((EObject)this.leftElement));
            }
            return sb.toString();
        }

        public String casePackage(Package object) {
            return "";
        }

        public String caseClass(Class object) {
            return DitaCompare.getEscapedElementName((NamedElement)object);
        }

        public String defaultCase(EObject object) {
            return (String)Display.DISPLAYINSTANCE.doSwitch(object);
        }
    }

    static class Display
    extends UMLSwitch<String> {
        static final Display DISPLAYINSTANCE = new Display();

        Display() {
        }

        public String caseNamedElement(NamedElement object) {
            if (object.getName() != null) {
                return DitaCompare.getEscapedElementName(object);
            }
            return (String)super.caseNamedElement(object);
        }

        public String caseClassifier(Classifier object) {
            return "Class " + DitaCompare.getEscapedElementName((NamedElement)object);
        }

        public String casePackage(Package object) {
            return "Package " + DitaCompare.getEscapedElementName((NamedElement)object);
        }

        public String caseProperty(Property object) {
            return "Property " + DitaCompare.getEscapedElementName((NamedElement)object) + " [" + object.getLower() + ".." + (object.getUpper() >= 0 ? Integer.valueOf(object.getUpper()) : "*") + "] " + (object.getType() != null ? object.getType().getName() : "NULL");
        }

        public String caseAssociation(Association assocation) {
            StringBuffer result = new StringBuffer();
            for (Property p : assocation.getMemberEnds()) {
                if (StringUtils.isEmpty((String)p.getName())) continue;
                result.append("Association from ");
                result.append(p.getOwner() instanceof Class ? String.valueOf(DitaCompare.getEscapedElementName((NamedElement)((Class)p.getOwner()))) + " " : "");
                result.append("::" + DitaCompare.getEscapedElementName((NamedElement)p) + " to ").append(DitaCompare.getEscapedElementName((NamedElement)p.getType()));
            }
            return result.toString();
        }

        public String caseComment(Comment comment) {
            return StringEscapeUtils.escapeHtml((String)comment.getBody());
        }

        public String caseGeneralization(Generalization generalization) {
            StringBuilder sb = new StringBuilder();
            sb.append("Generalization from ");
            if (generalization.getSpecific() != null) {
                sb.append(String.valueOf(generalization.getSpecific().getName()) + " to ");
            } else {
                sb.append(" null to ");
            }
            if (generalization.getGeneral() != null) {
                sb.append(generalization.getGeneral().getName());
            } else {
                sb.append(" null ");
            }
            return sb.toString();
        }

        public String caseLiteralUnlimitedNatural(LiteralUnlimitedNatural lun) {
            return String.valueOf(lun.getValue());
        }

        public String caseLiteralInteger(LiteralInteger li) {
            return String.valueOf(li.getValue());
        }

        public String defaultCase(EObject object) {
            return object.getClass().getName();
        }
    }

    static class ElementDisplay
    extends UMLSwitch<String> {
        static final ElementDisplay ELEMENTDISPLAYINSTANCE = new ElementDisplay();

        ElementDisplay() {
        }

        public String caseProperty(Property object) {
            return "Property " + DitaCompare.getEscapedElementName((NamedElement)object);
        }

        public String caseComment(Comment object) {
            return "Comment ";
        }

        public String caseGeneralization(Generalization generalization) {
            return "Generalization";
        }

        public String caseEnumeration(Enumeration object) {
            return "Enumeration " + DitaCompare.getEscapedElementName((NamedElement)object);
        }

        public String caseNamedElement(NamedElement object) {
            return DitaCompare.getEscapedElementName(object);
        }

        public String defaultCase(EObject object) {
            return object.toString();
        }
    }
}

