/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.internal.sections;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mdht.uml.common.ui.util.EnumerationLabelProvider;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.EvaluationModeKind;
import org.eclipse.mdht.uml.validation.SeverityKind;
import org.eclipse.mdht.uml.validation.ValidationPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;

public class ConstraintDiagnosticSection
extends WrapperAwareModelerPropertySection {
    private Constraint constraint;
    private Diagnostic diagnostic;
    private ComboViewer evaluationModePicker;
    private ComboViewer severityPicker;
    private Text messageText;
    private Text statusCodeText;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ConstraintDiagnosticSection.this.dirty = true;
        }
    };
    private ModifyListener textListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ConstraintDiagnosticSection.this.dirty = true;
        }
    };
    private KeyListener acceptListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r' || e.keyCode == 0x1000050) {
                ConstraintDiagnosticSection.this.updateModel();
            }
        }
    };
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent event) {
            ConstraintDiagnosticSection.this.updateModel();
        }
    };
    private VerifyListener intValidator = new VerifyListener(){

        public void verifyText(VerifyEvent e) {
            int len = e.text.length();
            if (len > 0) {
                int i = 0;
                if (e.text.charAt(i) == '-') {
                    if (e.start > 0) {
                        e.text = "";
                        return;
                    }
                    ++i;
                }
                while (i < len) {
                    char c = e.text.charAt(i);
                    if (c < '0' || c > '9') {
                        e.text = "";
                        return;
                    }
                    ++i;
                }
            }
        }
    };
    private boolean dirty;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        Point point = gc.textExtent("M");
        int charHeight = point.y;
        int charWidth = point.x;
        gc.dispose();
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        CLabel label = this.getWidgetFactory().createCLabel(composite, "Evaluation Mode:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        label.setLayoutData((Object)data);
        this.evaluationModePicker = new ComboViewer(new Combo(composite, 12));
        this.getWidgetFactory().adapt(this.evaluationModePicker.getControl(), true, false);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 0, 131072);
        data.top = new FormAttachment((Control)label, 0, 0x1000000);
        this.evaluationModePicker.getControl().setLayoutData((Object)data);
        this.evaluationModePicker.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.evaluationModePicker.setLabelProvider((IBaseLabelProvider)EnumerationLabelProvider.of(EvaluationModeKind.class).label((Enum)EvaluationModeKind.BATCH, "Batch").label((Enum)EvaluationModeKind.LIVE, "Live"));
        this.evaluationModePicker.setInput((Object)EvaluationModeKind.VALUES);
        label = this.getWidgetFactory().createCLabel(composite, "Severity:");
        data = new FormData();
        data.left = new FormAttachment(this.evaluationModePicker.getControl(), 0, 131072);
        data.top = new FormAttachment(0, 0);
        label.setLayoutData((Object)data);
        this.severityPicker = new ComboViewer(new Combo(composite, 12));
        this.getWidgetFactory().adapt(this.severityPicker.getControl(), true, false);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 0, 131072);
        data.top = new FormAttachment((Control)label, 0, 0x1000000);
        this.severityPicker.getControl().setLayoutData((Object)data);
        this.severityPicker.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.severityPicker.setLabelProvider((IBaseLabelProvider)EnumerationLabelProvider.of(SeverityKind.class).labels(new String[]{"Informational", "Warning", "Error"}));
        this.severityPicker.setInput((Object)SeverityKind.VALUES);
        label = this.getWidgetFactory().createCLabel(composite, "Status Code:");
        data = new FormData();
        data.left = new FormAttachment(this.severityPicker.getControl(), 0, 131072);
        data.top = new FormAttachment(0, 0);
        label.setLayoutData((Object)data);
        this.statusCodeText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)label, 0, 131072);
        data.top = new FormAttachment((Control)label, 0, 0x1000000);
        data.width = 6 * charWidth;
        this.statusCodeText.setLayoutData((Object)data);
        label = this.getWidgetFactory().createCLabel(composite, "Message:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(this.evaluationModePicker.getControl(), 0, 1024);
        label.setLayoutData((Object)data);
        this.messageText = this.getWidgetFactory().createText(composite, "", 578);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 0, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)label, 0, 128);
        data.height = 5 * charHeight / 2;
        this.messageText.setLayoutData((Object)data);
    }

    private void hookListeners() {
        this.evaluationModePicker.addSelectionChangedListener(this.selectionListener);
        this.severityPicker.addSelectionChangedListener(this.selectionListener);
        this.statusCodeText.addModifyListener(this.textListener);
        this.messageText.addModifyListener(this.textListener);
        this.statusCodeText.addKeyListener(this.acceptListener);
        this.messageText.addKeyListener(this.acceptListener);
        this.evaluationModePicker.getControl().addFocusListener(this.focusListener);
        this.severityPicker.getControl().addFocusListener(this.focusListener);
        this.statusCodeText.addFocusListener(this.focusListener);
        this.messageText.addFocusListener(this.focusListener);
        this.statusCodeText.addVerifyListener(this.intValidator);
    }

    private void unhookListeners() {
        this.evaluationModePicker.removeSelectionChangedListener(this.selectionListener);
        this.severityPicker.removeSelectionChangedListener(this.selectionListener);
        this.statusCodeText.removeModifyListener(this.textListener);
        this.messageText.removeModifyListener(this.textListener);
        this.statusCodeText.removeKeyListener(this.acceptListener);
        this.messageText.removeKeyListener(this.acceptListener);
        this.evaluationModePicker.getControl().removeFocusListener(this.focusListener);
        this.severityPicker.getControl().removeFocusListener(this.focusListener);
        this.statusCodeText.removeFocusListener(this.focusListener);
        this.messageText.removeFocusListener(this.focusListener);
        this.statusCodeText.removeVerifyListener(this.intValidator);
    }

    @Override
    protected boolean isReadOnly() {
        boolean result = super.isReadOnly();
        if (!result) {
            if (this.diagnostic == null) {
                result = true;
            } else {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.constraint);
                if (editingDomain != null && editingDomain.isReadOnly(this.constraint.eResource())) {
                    result = true;
                }
            }
        }
        return result;
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof Constraint));
        this.constraint = (Constraint)element;
        this.diagnostic = (Diagnostic)EcoreUtil.getObjectByType((Collection)this.constraint.getStereotypeApplications(), (EClassifier)ValidationPackage.Literals.DIAGNOSTIC);
    }

    public void refresh() {
        this.unhookListeners();
        if (this.evaluationModePicker != null && this.diagnostic != null) {
            this.evaluationModePicker.setSelection((ISelection)new StructuredSelection((Object)this.diagnostic.getEvaluationMode()));
            this.severityPicker.setSelection((ISelection)new StructuredSelection((Object)this.diagnostic.getSeverity()));
            this.statusCodeText.setText(this.diagnostic.isSetCode() ? Integer.toString(this.diagnostic.getCode()) : "");
            this.messageText.setText(this.diagnostic.getMessage() == null ? "" : this.diagnostic.getMessage().trim());
            if (!this.isReadOnly()) {
                this.hookListeners();
            }
        }
        boolean enable = !this.isReadOnly();
        this.evaluationModePicker.getControl().setEnabled(enable);
        this.severityPicker.getControl().setEnabled(enable);
        this.statusCodeText.setEnabled(enable);
        this.messageText.setEnabled(enable);
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ConstraintDiagnosticSection.this.isDisposed() && ConstraintDiagnosticSection.this.constraint.eResource() != null) {
                        ConstraintDiagnosticSection.this.refresh();
                    }
                }
            });
        }
    }

    private void updateModel() {
        if (this.dirty) {
            this.execute((IUndoableOperation)new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)this.constraint), "Change Diagnostic Properties"){

                protected IStatus doExecute(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
                    String message;
                    String codeStr;
                    boolean changed = false;
                    EvaluationModeKind evalMode = (EvaluationModeKind)ConstraintDiagnosticSection.this.getSelectedValue((ISelectionProvider)ConstraintDiagnosticSection.this.evaluationModePicker, EvaluationModeKind.class);
                    if (ConstraintDiagnosticSection.this.diagnostic.getEvaluationMode() != evalMode) {
                        changed = true;
                        ConstraintDiagnosticSection.this.diagnostic.setEvaluationMode(evalMode);
                    }
                    SeverityKind sev = (SeverityKind)ConstraintDiagnosticSection.this.getSelectedValue((ISelectionProvider)ConstraintDiagnosticSection.this.severityPicker, SeverityKind.class);
                    if (ConstraintDiagnosticSection.this.diagnostic.getSeverity() != sev) {
                        changed = true;
                        ConstraintDiagnosticSection.this.diagnostic.setSeverity(sev);
                    }
                    if ((codeStr = ConstraintDiagnosticSection.this.statusCodeText.getText().trim()).length() == 0) {
                        if (ConstraintDiagnosticSection.this.diagnostic.isSetCode()) {
                            changed = true;
                            ConstraintDiagnosticSection.this.diagnostic.unsetCode();
                        }
                    } else {
                        int code = Integer.valueOf(codeStr);
                        if (ConstraintDiagnosticSection.this.diagnostic.getCode() != code) {
                            changed = true;
                            ConstraintDiagnosticSection.this.diagnostic.setCode(code);
                        }
                    }
                    if ((message = ConstraintDiagnosticSection.this.messageText.getText().trim()).length() == 0) {
                        if (ConstraintDiagnosticSection.this.diagnostic.getMessage() != null) {
                            changed = true;
                            ConstraintDiagnosticSection.this.diagnostic.setMessage(null);
                        }
                    } else if (!UML2Util.safeEquals((Object)ConstraintDiagnosticSection.this.diagnostic.getMessage(), (Object)message)) {
                        changed = true;
                        ConstraintDiagnosticSection.this.diagnostic.setMessage(message);
                    }
                    return changed ? Status.OK_STATUS : Status.CANCEL_STATUS;
                }
            });
            this.dirty = false;
        }
    }

    private <T> T getSelectedValue(ISelectionProvider selectionProvider, Class<T> type) {
        IStructuredSelection sel = (IStructuredSelection)selectionProvider.getSelection();
        return sel.isEmpty() ? null : (T)type.cast(sel.getFirstElement());
    }
}

