/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_TS;
import org.eclipse.mdht.uml.hl7.datatypes.IVXB_TS;
import org.eclipse.mdht.uml.hl7.datatypes.PQ;
import org.eclipse.mdht.uml.hl7.datatypes.TS;

public class IVLTSTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (IVLTSTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption1LowOnly() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oLow = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidth() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oLow = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setLow(oLow);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlTs.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithHigh() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oLow = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setLow(oLow);
        IVXB_TS oHigh = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption1LowWithWidthAndHigh_FailureCase() {
        boolean bResult = true;
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oLow = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setLow(oLow);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlTs.setWidth(oWidth);
        IVXB_TS oHigh = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        if (!IVLTSTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption2HighOnly() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oHigh = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption2HighWithCenter_FailureCase() {
        boolean bResult = true;
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        IVXB_TS oHigh = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setHigh(oHigh);
        TS oCenter = DatatypesFactory.eINSTANCE.createTS();
        oIvlTs.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        if (!IVLTSTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOption3WidthOnly() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlTs.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption3WidthAndHigh() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlTs.setWidth(oWidth);
        IVXB_TS oHigh = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setHigh(oHigh);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterOnly() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        TS oCenter = DatatypesFactory.eINSTANCE.createTS();
        oIvlTs.setCenter(oCenter);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndWidth() {
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        TS oCenter = DatatypesFactory.eINSTANCE.createTS();
        oIvlTs.setCenter(oCenter);
        PQ oWidth = DatatypesFactory.eINSTANCE.createPQ();
        oIvlTs.setWidth(oWidth);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        return IVLTSTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testOption4CenterAndLow_FailureCase() {
        boolean bResult = true;
        IVL_TS oIvlTs = DatatypesFactory.eINSTANCE.createIVL_TS();
        TS oCenter = DatatypesFactory.eINSTANCE.createTS();
        oIvlTs.setCenter(oCenter);
        IVXB_TS oLow = DatatypesFactory.eINSTANCE.createIVXB_TS();
        oIvlTs.setLow(oLow);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oIvlTs);
        if (!IVLTSTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!IVLTSTest.testOption1LowOnly()) {
            bFailure = true;
            System.out.println("testOption1LowOnly failed!");
        }
        if (!IVLTSTest.testOption1LowWithWidth()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidth failed!");
        }
        if (!IVLTSTest.testOption1LowWithHigh()) {
            bFailure = true;
            System.out.println("testOption1LowWithHigh failed!");
        }
        if (!IVLTSTest.testOption1LowWithWidthAndHigh_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLTSTest.testOption2HighOnly()) {
            bFailure = true;
            System.out.println("testOption2HighOnly failed!");
        }
        if (!IVLTSTest.testOption2HighWithCenter_FailureCase()) {
            bFailure = true;
            System.out.println("testOption1LowWithWidthAndHigh_FailureCase failed!");
        }
        if (!IVLTSTest.testOption3WidthOnly()) {
            bFailure = true;
            System.out.println("testOption3WidthOnly failed!");
        }
        if (!IVLTSTest.testOption3WidthAndHigh()) {
            bFailure = true;
            System.out.println("testOption3WidthAndHigh failed!");
        }
        if (!IVLTSTest.testOption4CenterOnly()) {
            bFailure = true;
            System.out.println("testOption4CenterOnly failed!");
        }
        if (!IVLTSTest.testOption4CenterAndWidth()) {
            bFailure = true;
            System.out.println("testOption4CenterAndWidth failed!");
        }
        if (!IVLTSTest.testOption4CenterAndLow_FailureCase()) {
            bFailure = true;
            System.out.println("testOption4CenterAndLow_FailureCase failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

