/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class AirlinesAppTest
extends AppTestBase {
    @Deployment(name="airlines")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"airlines.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.airlines"})).addAsManifestResource("openapi.yaml", "openapi.yaml");
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testVersion(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("openapi", Matchers.startsWith((String)"3.0."), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testInfo(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.title", Matchers.equalTo((Object)"AirlinesRatingApp API"), new Object[0]);
        vr.body("info.version", Matchers.equalTo((Object)"1.0"), new Object[0]);
        vr.body("info.termsOfService", Matchers.equalTo((Object)"http://airlinesratingapp.com/terms"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContact(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.contact.name", Matchers.equalTo((Object)"AirlinesRatingApp API Support"), new Object[0]);
        vr.body("info.contact.url", Matchers.equalTo((Object)"http://exampleurl.com/contact"), new Object[0]);
        vr.body("info.contact.email", Matchers.equalTo((Object)"techsupport@airlinesratingapp.com"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testLicense(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.license.name", Matchers.equalTo((Object)"Apache 2.0"), new Object[0]);
        vr.body("info.license.url", Matchers.equalTo((Object)"http://www.apache.org/licenses/LICENSE-2.0.html"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExternalDocumentation(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("externalDocs.description", Matchers.equalTo((Object)"instructions for how to deploy this app"), new Object[0]);
        vr.body("externalDocs.url", Matchers.containsString((String)"README.md"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testServer(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("servers", Matchers.hasSize((int)2), new Object[0]);
        vr.body("servers.url", Matchers.hasSize((int)2), new Object[0]);
        String url = "https://{username}.gigantic-server.com:{port}/{basePath}";
        String serverPath = "servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"The production API server"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)4), new Object[0]);
        vr.body(serverPath + ".variables.username.description", Matchers.equalTo((Object)"Reviews of the app by users"), new Object[0]);
        vr.body(serverPath + ".variables.username.default", Matchers.equalTo((Object)"user1"), new Object[0]);
        vr.body(serverPath + ".variables.username.enum", Matchers.containsInAnyOrder((Object[])new String[]{"user1", "user2"}), new Object[0]);
        vr.body(serverPath + ".variables.port.description", Matchers.equalTo((Object)"Booking data"), new Object[0]);
        vr.body(serverPath + ".variables.port.default", Matchers.equalTo((Object)"8443"), new Object[0]);
        vr.body(serverPath + ".variables.user.description", Matchers.equalTo((Object)"User data"), new Object[0]);
        vr.body(serverPath + ".variables.user.default", Matchers.equalTo((Object)"user"), new Object[0]);
        vr.body(serverPath + ".variables.basePath.default", Matchers.equalTo((Object)"v2"), new Object[0]);
        url = "https://test-server.com:80/basePath";
        serverPath = "servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"The test API server"), new Object[0]);
        vr.body("paths.'/reviews/{id}'.delete.servers", Matchers.hasSize((int)3), new Object[0]);
        vr.body("paths.'/reviews/{id}'.delete.servers.url", Matchers.hasSize((int)3), new Object[0]);
        url = "https://gigantic-server.com:443";
        serverPath = "paths.'/reviews/{id}'.delete.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"Secure server"), new Object[0]);
        url = "http://gigantic-server.com:80";
        serverPath = "paths.'/reviews/{id}'.delete.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"Unsecure server"), new Object[0]);
        vr.body(serverPath + ".variables", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
        url = "{protocol}://test-server.com";
        serverPath = "paths.'/reviews/{id}'.delete.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"The production API server"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)1), new Object[0]);
        vr.body(serverPath + ".variables.protocol.default", Matchers.equalTo((Object)"https"), new Object[0]);
        vr.body(serverPath + ".variables.protocol.enum", Matchers.containsInAnyOrder((Object[])new String[]{"http", "https"}), new Object[0]);
        vr.body("paths.'/reviews'.post.servers", Matchers.hasSize((int)2), new Object[0]);
        vr.body("paths.'/reviews'.post.servers.url", Matchers.hasSize((int)2), new Object[0]);
        url = "localhost:9080/{proxyPath}/reviews/id";
        serverPath = "paths.'/reviews'.post.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"view of all the reviews"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)1), new Object[0]);
        vr.body(serverPath + ".variables.proxyPath.description", Matchers.equalTo((Object)"Base path of the proxy"), new Object[0]);
        vr.body(serverPath + ".variables.proxyPath.default", Matchers.equalTo((Object)"proxy"), new Object[0]);
        url = "http://random.url/reviews";
        serverPath = "paths.'/reviews'.post.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"random text"), new Object[0]);
        vr.body("paths.'/bookings'.get.servers", Matchers.hasSize((int)2), new Object[0]);
        vr.body("paths.'/bookings'.get.servers.url", Matchers.hasSize((int)2), new Object[0]);
        url = "http://gigantic-server.com:80";
        serverPath = "paths.'/bookings'.get.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"Unsecure server"), new Object[0]);
        vr.body(serverPath + ".variables", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
        url = "https://gigantic-server.com:443";
        serverPath = "paths.'/bookings'.get.servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"Secure server"), new Object[0]);
        vr.body(serverPath + ".variables", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationAirlinesResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/'.get.summary", Matchers.equalTo((Object)"Retrieve all available airlines"), new Object[0]);
        vr.body("paths.'/'.get.operationId", Matchers.equalTo((Object)"getAirlines"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationAvailabilityResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.summary", Matchers.equalTo((Object)"Retrieve all available flights"), new Object[0]);
        vr.body("paths.'/availability'.get.operationId", Matchers.equalTo((Object)"getFlights"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testRestClientNotPickedUp(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/player/{playerId}'", Matchers.equalTo(null), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationBookingResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/bookings'.get.summary", Matchers.equalTo((Object)"Retrieve all bookings for current user"), new Object[0]);
        vr.body("paths.'/bookings'.get.operationId", Matchers.equalTo((Object)"getAllBookings"), new Object[0]);
        vr.body("paths.'/bookings'.post.summary", Matchers.equalTo((Object)"Create a booking"), new Object[0]);
        vr.body("paths.'/bookings'.post.description", Matchers.equalTo((Object)"Create a new booking record with the booking information provided."), new Object[0]);
        vr.body("paths.'/bookings'.post.operationId", Matchers.equalTo((Object)"createBooking"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.summary", Matchers.equalTo((Object)"Get a booking with ID"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.operationId", Matchers.equalTo((Object)"getBookingById"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.put.summary", Matchers.equalTo((Object)"Update a booking with ID"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.put.operationId", Matchers.equalTo((Object)"updateBookingId"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.delete.summary", Matchers.equalTo((Object)"Delete a booking with ID"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.delete.operationId", Matchers.equalTo((Object)"deleteBookingById"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationReviewResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/reviews'.get.summary", Matchers.equalTo((Object)"get all the reviews"), new Object[0]);
        vr.body("paths.'/reviews'.get.operationId", Matchers.equalTo((Object)"getAllReviews"), new Object[0]);
        vr.body("paths.'/reviews'.post.summary", Matchers.equalTo((Object)"Create a Review"), new Object[0]);
        vr.body("paths.'/reviews'.post.operationId", Matchers.equalTo((Object)"createReview"), new Object[0]);
        vr.body("paths.'/reviews/{id}'.get.summary", Matchers.equalTo((Object)"Get a review with ID"), new Object[0]);
        vr.body("paths.'/reviews/{id}'.get.operationId", Matchers.equalTo((Object)"getReviewById"), new Object[0]);
        vr.body("paths.'/reviews/{id}'.delete.summary", Matchers.equalTo((Object)"Delete a Review with ID"), new Object[0]);
        vr.body("paths.'/reviews/{id}'.delete.operationId", Matchers.equalTo((Object)"deleteReview"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.summary", Matchers.equalTo((Object)"Get all reviews by user"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.operationId", Matchers.equalTo((Object)"getReviewByUser"), new Object[0]);
        vr.body("paths.'/reviews/airlines/{airline}'.get.summary", Matchers.equalTo((Object)"Get all reviews by airlines"), new Object[0]);
        vr.body("paths.'/reviews/airlines/{airline}'.get.operationId", Matchers.equalTo((Object)"getReviewByAirline"), new Object[0]);
        vr.body("paths.'/reviews/{user}/{airlines}'.get.summary", Matchers.equalTo((Object)"Get all reviews for an airline by User"), new Object[0]);
        vr.body("paths.'/reviews/{user}/{airlines}'.get.operationId", Matchers.equalTo((Object)"getReviewByAirlineAndUser"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationUserResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/user'.post.summary", Matchers.equalTo((Object)"Create user"), new Object[0]);
        vr.body("paths.'/user'.post.description", Matchers.equalTo((Object)"This can only be done by the logged in user."), new Object[0]);
        vr.body("paths.'/user'.post.operationId", Matchers.equalTo((Object)"createUser"), new Object[0]);
        vr.body("paths.'/user/createWithArray'.post.summary", Matchers.equalTo((Object)"Creates list of users with given input array"), new Object[0]);
        vr.body("paths.'/user/createWithArray'.post.operationId", Matchers.equalTo((Object)"createUsersFromArray"), new Object[0]);
        vr.body("paths.'/user/createWithList'.post.summary", Matchers.equalTo((Object)"Creates list of users with given input list"), new Object[0]);
        vr.body("paths.'/user/createWithList'.post.operationId", Matchers.equalTo((Object)"createUsersFromList"), new Object[0]);
        vr.body("paths.'/user/{username}'.put.summary", Matchers.equalTo((Object)"Update user"), new Object[0]);
        vr.body("paths.'/user/{username}'.put.description", Matchers.equalTo((Object)"This can only be done by the logged in user."), new Object[0]);
        vr.body("paths.'/user/{username}'.put.operationId", Matchers.equalTo((Object)"updateUser"), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.summary", Matchers.equalTo((Object)"Delete user"), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.description", Matchers.equalTo((Object)"This can only be done by the logged in user."), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.operationId", Matchers.equalTo((Object)"deleteUser"), new Object[0]);
        vr.body("paths.'/user/{username}'.get.summary", Matchers.equalTo((Object)"Get user by user name"), new Object[0]);
        vr.body("paths.'/user/{username}'.get.operationId", Matchers.equalTo((Object)"getUserByName"), new Object[0]);
        vr.body("paths.'/user/{id}'.get.summary", Matchers.equalTo((Object)"Get user by id"), new Object[0]);
        vr.body("paths.'/user/{id}'.get.operationId", Matchers.equalTo((Object)"getUserById"), new Object[0]);
        vr.body("paths.'/user/login'.get.summary", Matchers.equalTo((Object)"Logs user into the system"), new Object[0]);
        vr.body("paths.'/user/login'.get.operationId", Matchers.equalTo((Object)"logInUser"), new Object[0]);
        vr.body("paths.'/user/logout'.get.summary", Matchers.equalTo((Object)"Logs out current logged in user session"), new Object[0]);
        vr.body("paths.'/user/logout'.get.operationId", Matchers.equalTo((Object)"logOutUser"), new Object[0]);
        vr.body("paths.'/user/{username}'.patch.summary", Matchers.equalTo((Object)"Change user password"), new Object[0]);
        vr.body("paths.'/user/{username}'.patch.description", Matchers.equalTo((Object)"This changes the password for the logged in user."), new Object[0]);
        vr.body("paths.'/user/{username}'.patch.operationId", Matchers.equalTo((Object)"changePassword"), new Object[0]);
        vr.body("paths.'/user/{username}'.patch.parameters", Matchers.hasSize((int)3), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/availability'.get.responses.'200'.description", Matchers.equalTo((Object)"successful operation"), new Object[0]);
        vr.body("paths.'/availability'.get.responses.'404'.description", Matchers.equalTo((Object)"No available flights found"), new Object[0]);
        vr.body("paths.'/bookings'.post.responses", IsMapWithSize.aMapWithSize((int)1), new Object[0]);
        vr.body("paths.'/bookings'.post.responses.'201'.description", Matchers.equalTo((Object)"Booking created"), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.responses", IsMapWithSize.aMapWithSize((int)3), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.responses.'200'.description", Matchers.equalTo((Object)"User deleted successfully"), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.responses.'400'.description", Matchers.equalTo((Object)"Invalid username supplied"), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.responses.'404'.description", Matchers.equalTo((Object)"User not found"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testAPIResponses(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/bookings/{id}'.get.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.responses.'200'.description", Matchers.equalTo((Object)"Booking retrieved"), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.responses.'404'.description", Matchers.equalTo((Object)"Booking not found"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.responses.'200'.description", Matchers.equalTo((Object)"Review(s) retrieved"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.responses.'404'.description", Matchers.equalTo((Object)"Review(s) not found"), new Object[0]);
        vr.body("paths.'/user/{username}'.put.responses", IsMapWithSize.aMapWithSize((int)3), new Object[0]);
        vr.body("paths.'/user/{username}'.put.responses.'200'.description", Matchers.equalTo((Object)"User updated successfully"), new Object[0]);
        vr.body("paths.'/user/{username}'.put.responses.'400'.description", Matchers.equalTo((Object)"Invalid user supplied"), new Object[0]);
        vr.body("paths.'/user/{username}'.put.responses.'404'.description", Matchers.equalTo((Object)"User not found"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testParameter(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        this.testAvailabilityGetParamater(vr);
        this.testBookingIdMethods(vr);
        this.testReviewIdMethods(vr);
        this.testUserLoginMethods(vr);
    }

    private void testUserLoginMethods(ValidatableResponse vr) {
        String reviewParameters = "paths.'/user/login'.get.parameters";
        vr.body(reviewParameters, Matchers.hasSize((int)2), new Object[0]);
        vr.body(reviewParameters + ".findAll { it }.name", Matchers.hasItems((Object[])new String[]{"username", "password"}), new Object[0]);
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"username", "The user name for login"});
        list.add(new String[]{"password", "The password for login in clear text"});
        for (int i = 0; i < list.size(); ++i) {
            String currentParam = ((String[])list.get(i))[0];
            String query = reviewParameters + ".findAll { it.name == '" + currentParam + "' }";
            vr.body(query + ".in", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"query"})), new Object[0]);
            vr.body(query + ".description", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{((String[])list.get(i))[1]})), new Object[0]);
            vr.body(query + ".required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
            vr.body(query + ".schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"string"})), new Object[0]);
        }
    }

    private void testReviewIdMethods(ValidatableResponse vr) {
        String reviewParameters = "paths.'/reviews/{id}'.get.parameters";
        vr.body(reviewParameters, Matchers.hasSize((int)1), new Object[0]);
        vr.body(reviewParameters + ".findAll { it }.name", Matchers.contains((Object[])new String[]{"id"}), new Object[0]);
        vr.body(reviewParameters + ".findAll { it.name == 'id' }.in", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"path"})), new Object[0]);
        vr.body(reviewParameters + ".findAll { it.name == 'id' }.description", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"ID of the booking"})), new Object[0]);
        vr.body(reviewParameters + ".findAll { it.name == 'id' }.required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
        vr.body(reviewParameters + ".findAll { it.name == 'id' }.content.'*/*'.schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"integer"})), new Object[0]);
    }

    private void testBookingIdMethods(ValidatableResponse vr) {
        String bookingParameters = "paths.'/bookings/{id}'.%s.parameters";
        for (String method : new String[]{"put", "delete", "get"}) {
            bookingParameters = String.format(bookingParameters, method);
            vr.body(bookingParameters, Matchers.hasSize((int)1), new Object[0]);
            vr.body(bookingParameters + ".findAll { it }.name", Matchers.contains((Object[])new String[]{"id"}), new Object[0]);
            vr.body(bookingParameters + ".findAll { it.name == 'id' }.required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
            vr.body(bookingParameters + ".findAll { it.name == 'id' }.schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"integer"})), new Object[0]);
        }
        bookingParameters = "paths.'/bookings/{id}'.get.parameters";
        vr.body(bookingParameters + ".findAll { it.name == 'id' }.style", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"simple"})), new Object[0]);
    }

    private void testAvailabilityGetParamater(ValidatableResponse vr) {
        String availabilityParameters = "paths.'/availability'.get.parameters";
        vr.body(availabilityParameters, Matchers.hasSize((int)6), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it }.name", Matchers.hasItems((Object[])new String[]{"airportFrom", "returningDate", "airportTo", "numberOfAdults", "numberOfChildren"}), new Object[0]);
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"airportFrom", "Airport the customer departs from"});
        list.add(new String[]{"returningDate", "Customer return date"});
        list.add(new String[]{"airportTo", "Airport the customer returns to"});
        list.add(new String[]{"numberOfAdults", "Number of adults on the flight"});
        list.add(new String[]{"numberOfChildren", "Number of children on the flight"});
        for (int i = 0; i < list.size(); ++i) {
            String currentParam = ((String[])list.get(i))[0];
            String query = availabilityParameters + ".findAll { it.name == '" + currentParam + "' }";
            vr.body(query + ".in", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"query"})), new Object[0]);
            vr.body(query + ".description", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{((String[])list.get(i))[1]})), new Object[0]);
            vr.body(query + ".required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
            vr.body(query + ".schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"string"})), new Object[0]);
        }
        vr.body(availabilityParameters + ".findAll { it.name == 'numberOfAdults' }.schema.minimum", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{0})), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it.name == 'numberOfChildren' }.schema.minimum", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{0})), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it.$ref == '#/components/parameters/departureDate'}", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExplode(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String explode = "paths.'/user/{username}'.put.responses.'200'.content.'application/xml'.encoding.password.explode";
        vr.body(explode, Matchers.equalTo((Object)true), new Object[0]);
        explode = "paths.'/user/{username}'.put.responses.'200'.content.'application/xml'.encoding.password.explode";
        vr.body(explode, Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testCallbackAnnotations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String endpoint = "paths.'/streams'.post.callbacks";
        vr.body(endpoint, Matchers.hasKey((Object)"onData"), new Object[0]);
        vr.body(endpoint + ".onData", Matchers.hasKey((Object)"{$request.query.callbackUrl}/data"), new Object[0]);
        endpoint = "paths.'/reviews'.post.callbacks";
        vr.body(endpoint, Matchers.hasKey((Object)"testCallback"), new Object[0]);
        vr.body(endpoint + ".testCallback", Matchers.hasKey((Object)"http://localhost:9080/oas3-airlines/reviews"), new Object[0]);
        endpoint = "paths.'/bookings'.post.callbacks";
        vr.body(endpoint, Matchers.hasKey((Object)"bookingCallback"), new Object[0]);
        vr.body(endpoint + ".'bookingCallback'", Matchers.hasKey((Object)"http://localhost:9080/airlines/bookings"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testCallbackOperationAnnotations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String endpoint = "paths.'/bookings'.post.callbacks.'bookingCallback'.'http://localhost:9080/airlines/bookings'";
        vr.body(endpoint, Matchers.hasKey((Object)"get"), new Object[0]);
        vr.body(endpoint + ".get.summary", Matchers.equalTo((Object)"Retrieve all bookings for current user"), new Object[0]);
        vr.body(endpoint + ".get.responses.'200'.description", Matchers.equalTo((Object)"Bookings retrieved"), new Object[0]);
        vr.body(endpoint + ".get.responses.'200'.content.'application/json'.schema.type", Matchers.equalTo((Object)"array"), new Object[0]);
        endpoint = "paths.'/reviews'.post.callbacks.testCallback.'http://localhost:9080/oas3-airlines/reviews'";
        vr.body(endpoint, Matchers.hasKey((Object)"get"), new Object[0]);
        vr.body(endpoint + ".get.summary", Matchers.equalTo((Object)"Get all reviews"), new Object[0]);
        vr.body(endpoint + ".get.responses.'200'.description", Matchers.equalTo((Object)"successful operation"), new Object[0]);
        vr.body(endpoint + ".get.responses.'200'.content.'application/json'.schema.type", Matchers.equalTo((Object)"array"), new Object[0]);
        vr.body(endpoint + ".get.responses.'200'.content.'application/json'.schema.items", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testRequestBodyAnnotations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String endpoint = "paths.'/bookings'.post.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"Create a new booking with the provided information."), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        endpoint = "paths.'/bookings/{id}'.put.requestBody";
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        endpoint = "paths.'/user'.post.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"Record of a new user to be created in the system."), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        vr.body(endpoint + ".required", Matchers.equalTo((Object)true), new Object[0]);
        endpoint = "paths.'/user/{username}'.put.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"Record of a new user to be created in the system."), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        endpoint = "paths.'/user/createWithArray'.post.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"Array of user object"), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        vr.body(endpoint + ".required", Matchers.equalTo((Object)true), new Object[0]);
        endpoint = "paths.'/user/createWithList'.post.requestBody";
        vr.body(endpoint + ".description", Matchers.equalTo((Object)"List of user object"), new Object[0]);
        vr.body(endpoint + ".content", Matchers.notNullValue(), new Object[0]);
        vr.body(endpoint + ".required", Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecurityRequirement(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("security.airlinesRatingApp_auth[0][0]", Matchers.equalTo(null), new Object[0]);
        vr.body("paths.'/reviews'.post.security.reviewoauth2[0][0]", Matchers.equalTo((Object)"write:reviews"), new Object[0]);
        vr.body("paths.'/reviews'.post.security.reviewoauth2", Matchers.hasSize((int)1), new Object[0]);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0][0]", Matchers.equalTo((Object)"write:bookings"), new Object[0]);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0][1]", Matchers.equalTo((Object)"read:bookings"), new Object[0]);
        vr.body("paths.'/reviews'.post.security.bookingSecurityScheme", Matchers.hasSize((int)1), new Object[0]);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0]", Matchers.hasSize((int)2), new Object[0]);
        vr.body("paths.'/user'.post.security.httpSchemeForTest[0][0]", Matchers.equalTo(null), new Object[0]);
        vr.body("paths.'/user/login'.get.security.find { it.httpTestScheme != null }.httpTestScheme", IsEmptyCollection.empty(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecuritySchemes(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "components.securitySchemes";
        vr.body(s, Matchers.hasKey((Object)"httpSchemeForTest"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"airlinesRatingApp_auth"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"reviewoauth2"), new Object[0]);
        vr.body(s, Matchers.hasKey((Object)"bookingSecurityScheme"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecurityScheme(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String http = "components.securitySchemes.httpSchemeForTest.";
        vr.body(http + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(http + "description", Matchers.equalTo((Object)"user security scheme"), new Object[0]);
        vr.body(http + "scheme", Matchers.equalTo((Object)"testScheme"), new Object[0]);
        String booking = "components.securitySchemes.bookingSecurityScheme.";
        vr.body(booking + "type", Matchers.equalTo((Object)"openIdConnect"), new Object[0]);
        vr.body(booking + "description", Matchers.equalTo((Object)"Security Scheme for booking resource"), new Object[0]);
        vr.body(booking + "openIdConnectUrl", Matchers.equalTo((Object)"http://openidconnect.com/testurl"), new Object[0]);
        String auth = "components.securitySchemes.airlinesRatingApp_auth.";
        vr.body(auth + "type", Matchers.equalTo((Object)"apiKey"), new Object[0]);
        vr.body(auth + "description", Matchers.equalTo((Object)"authentication needed to access Airlines app"), new Object[0]);
        vr.body(auth + "name", Matchers.equalTo((Object)"api_key"), new Object[0]);
        vr.body(auth + "in", Matchers.equalTo((Object)"header"), new Object[0]);
        String reviewoauth2 = "components.securitySchemes.reviewoauth2.";
        vr.body(reviewoauth2 + "type", Matchers.equalTo((Object)"oauth2"), new Object[0]);
        vr.body(reviewoauth2 + "description", Matchers.equalTo((Object)"authentication needed to create and delete reviews"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOAuthFlows(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String t = "components.securitySchemes.reviewoauth2.flows";
        vr.body(t, Matchers.hasKey((Object)"implicit"), new Object[0]);
        vr.body(t, Matchers.hasKey((Object)"authorizationCode"), new Object[0]);
        vr.body(t, Matchers.hasKey((Object)"password"), new Object[0]);
        vr.body(t, Matchers.hasKey((Object)"clientCredentials"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOAuthFlow(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String implicit = "components.securitySchemes.reviewoauth2.flows.implicit.";
        vr.body(implicit + "authorizationUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/dialog"), new Object[0]);
        String authCode = "components.securitySchemes.reviewoauth2.flows.authorizationCode.";
        vr.body(authCode + "authorizationUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/dialog"), new Object[0]);
        vr.body(authCode + "tokenUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/token"), new Object[0]);
        String password = "components.securitySchemes.reviewoauth2.flows.password.";
        vr.body(password + "refreshUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/refresh"), new Object[0]);
        String client = "components.securitySchemes.reviewoauth2.flows.clientCredentials.";
        vr.body(client + "tokenUrl", Matchers.equalTo((Object)"https://example.com/api/oauth/token"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOAuthScope(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String implicit = "components.securitySchemes.reviewoauth2.flows.implicit.";
        vr.body(implicit + "scopes.'write:reviews'", Matchers.equalTo((Object)"create a review"), new Object[0]);
        String client = "components.securitySchemes.reviewoauth2.flows.clientCredentials.";
        vr.body(client + "scopes.'read:reviews'", Matchers.equalTo((Object)"search for a review"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testEncodingRequestBody(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "paths.'/user'.post.requestBody.content.'application/json'.encoding.email.";
        vr.body(s + "contentType", Matchers.equalTo((Object)"text/plain"), new Object[0]);
        vr.body(s + "style", Matchers.equalTo((Object)"form"), new Object[0]);
        vr.body(s + "explode", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(s + "allowReserved", Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testEncodingResponses(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "paths.'/user/{username}'.put.responses.'200'.content.'application/json'.encoding.password.";
        vr.body(s + "contentType", Matchers.equalTo((Object)"text/plain"), new Object[0]);
        vr.body(s + "style", Matchers.equalTo((Object)"form"), new Object[0]);
        vr.body(s + "explode", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(s + "allowReserved", Matchers.equalTo((Object)true), new Object[0]);
        String t = "paths.'/user/{username}'.put.responses.'200'.content.'application/xml'.encoding.password.";
        vr.body(t + "contentType", Matchers.equalTo((Object)"text/plain"), new Object[0]);
        vr.body(t + "style", Matchers.equalTo((Object)"form"), new Object[0]);
        vr.body(t + "explode", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(t + "allowReserved", Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testLink(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "paths.'/user/{id}'.get.responses.'200'.links.'User name'.";
        vr.body(s + "operationId", Matchers.equalTo((Object)"getUserByName"), new Object[0]);
        vr.body(s + "description", Matchers.equalTo((Object)"The username corresponding to provided user id"), new Object[0]);
        String t = "paths.'/user/{id}'.get.responses.'200'.links.Review.";
        vr.body(t + "operationRef", Matchers.equalTo((Object)"/db/reviews/{userName}"), new Object[0]);
        vr.body(t + "description", Matchers.equalTo((Object)"The reviews provided by user"), new Object[0]);
        String k = "paths.'/reviews'.post.responses.'201'.links.Review.";
        vr.body(k + "operationId", Matchers.equalTo((Object)"getReviewById"), new Object[0]);
        vr.body(k + "description", Matchers.equalTo((Object)"get the review that was added"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testLinkParameter(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "paths.'/user/{id}'.get.responses.'200'.links.'User name'.";
        vr.body(s + "parameters.userId", Matchers.equalTo((Object)"$request.path.id"), new Object[0]);
        String t = "paths.'/user/{id}'.get.responses.'200'.links.Review.";
        vr.body(t + "parameters.'path.userName'", Matchers.equalTo((Object)"$response.body#userName"), new Object[0]);
        String k = "paths.'/reviews'.post.responses.'201'.links.Review.";
        vr.body(k + "parameters.reviewId", Matchers.equalTo((Object)"$request.path.id"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.AirlinesRef.$ref", Matchers.equalTo((Object)"#/components/schemas/Airlines"), new Object[0]);
        vr.body("components.schemas.Airlines.title", Matchers.equalTo((Object)"Airlines"), new Object[0]);
        vr.body("paths.'/bookings'.post.responses.'201'.content.'application/json'.schema.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("components.schemas.id.format", Matchers.equalTo((Object)"int32"), new Object[0]);
        vr.body("paths.'/bookings'.post.responses.'201'.content.'application/json'.schema.description", Matchers.equalTo((Object)"id of the new booking"), new Object[0]);
        vr.body("components.schemas.User.properties.password.example", Matchers.equalTo((Object)"bobSm37"), new Object[0]);
        vr.body("paths.'/user'.post.requestBody.content.'application/json'.schema.maxProperties", Matchers.equalTo((Object)1024), new Object[0]);
        vr.body("paths.'/user'.post.requestBody.content.'application/json'.schema.minProperties", Matchers.equalTo((Object)1), new Object[0]);
        vr.body("components.schemas.User.required", Matchers.hasItems((Object[])new String[]{"id", "username", "password"}), new Object[0]);
        vr.body("components.schemas.Gender.enum", Matchers.hasItems((Object[])new String[]{"Male", "Female", "Other"}), new Object[0]);
        String createSchema = "paths.'/user/createWithArray'.post.requestBody.content.'application/json'.schema";
        vr.body(createSchema + ".nullable", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(createSchema + ".writeOnly", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(createSchema + ".maxItems", Matchers.equalTo((Object)20), new Object[0]);
        vr.body(createSchema + ".minItems", Matchers.equalTo((Object)2), new Object[0]);
        vr.body(createSchema + ".uniqueItems", Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSchemaProperty(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.User.properties", IsMapWithSize.aMapWithSize((int)10), new Object[0]);
        vr.body("components.schemas.User.properties.phone.example", Matchers.equalTo((Object)"123-456-7890"), new Object[0]);
        vr.body("components.schemas.User.properties.phone.description", Matchers.equalTo((Object)"Telephone number to contact the user"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExampleObject(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.examples.review.summary", Matchers.equalTo((Object)"External review example"), new Object[0]);
        vr.body("components.examples.review.description", Matchers.equalTo((Object)"This example exemplifies the content on our site."), new Object[0]);
        vr.body("components.examples.review.externalValue", Matchers.equalTo((Object)"http://foo.bar/examples/review-example.json"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.parameters.find{ it.name=='user'}.content.'*/*'.examples.example.value", Matchers.equalTo((Object)"bsmith"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.parameters.find{ it.name=='user'}.examples.example1.value", Matchers.equalTo((Object)"bsmith"), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.parameters.find{ it.name=='user'}.examples.example2.value", Matchers.equalTo((Object)"pat@example.com"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContentExampleAttribute(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/reviews/{user}/{airlines}'.get.parameters.find{it.name=='airlines'}.content.'*/*'.example", Matchers.equalTo((Object)"Acme Air"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testTagDeclarations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String tagsPath = "tags.find { it.name == '";
        String desc = "' }.description";
        vr.body(tagsPath + "user" + desc, Matchers.equalTo((Object)"Operations about user"), new Object[0]);
        vr.body(tagsPath + "create" + desc, Matchers.equalTo((Object)"Operations about create"), new Object[0]);
        vr.body(tagsPath + "Airlines" + desc, Matchers.equalTo((Object)"All the airlines methods"), new Object[0]);
        vr.body(tagsPath + "Availability" + desc, Matchers.equalTo((Object)"All the availability methods"), new Object[0]);
        vr.body(tagsPath + "Get Flights" + desc, Matchers.equalTo((Object)"method to retrieve all flights available"), new Object[0]);
        vr.body(tagsPath + "Get Flights' }.externalDocs.description", Matchers.equalTo((Object)"A list of all the flights offered by the app"), new Object[0]);
        vr.body(tagsPath + "Get Flights' }.externalDocs.url", Matchers.equalTo((Object)"http://airlinesratingapp.com/ourflights"), new Object[0]);
        vr.body(tagsPath + "Bookings" + desc, Matchers.equalTo((Object)"All the bookings methods"), new Object[0]);
        vr.body(tagsPath + "Reservations" + desc, Matchers.equalTo((Object)"All the reservation methods"), new Object[0]);
        vr.body(tagsPath + "Reviews" + desc, Matchers.equalTo((Object)"All the review methods"), new Object[0]);
        vr.body(tagsPath + "Ratings" + desc, Matchers.equalTo((Object)"All the ratings methods"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testTagsInOperations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Get Flights", "Availability"}), new Object[0]);
        vr.body("paths.'/bookings'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"bookings"}), new Object[0]);
        vr.body("paths.'/bookings'.post.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Bookings", "Reservations"}), new Object[0]);
        vr.body("paths.'/bookings/{id}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Bookings", "Reservations"}), new Object[0]);
        vr.body("paths.'/bookings/{id}'.put.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Bookings", "Reservations"}), new Object[0]);
        vr.body("paths.'/bookings/{id}'.delete.tags", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
        vr.body("paths.'/reviews'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/reviews'.post.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews"}), new Object[0]);
        vr.body("paths.'/reviews/{id}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/reviews/{id}'.delete.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/reviews/users/{user}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/reviews/airlines/{airline}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/reviews/{user}/{airlines}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Reviews", "Ratings"}), new Object[0]);
        vr.body("paths.'/user'.post.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user", "create"}), new Object[0]);
        vr.body("paths.'/user/createWithArray'.post.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user", "create"}), new Object[0]);
        vr.body("paths.'/user/createWithList'.post.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user", "create"}), new Object[0]);
        vr.body("paths.'/user/{username}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user"}), new Object[0]);
        vr.body("paths.'/user/{username}'.put.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user"}), new Object[0]);
        vr.body("paths.'/user/{username}'.delete.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user"}), new Object[0]);
        vr.body("paths.'/user/{id}'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"user"}), new Object[0]);
        vr.body("paths.'/user/login'.get.tags", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
        vr.body("paths.'/user/logout'.get.tags", Matchers.not((Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)))), new Object[0]);
        vr.body("paths.'/'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Airlines"}), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testComponents(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.Bookings", Matchers.notNullValue(), new Object[0]);
        vr.body("components.schemas.Airlines", Matchers.notNullValue(), new Object[0]);
        vr.body("components.schemas.AirlinesRef", Matchers.notNullValue(), new Object[0]);
        vr.body("components.responses.FoundAirlines", Matchers.notNullValue(), new Object[0]);
        vr.body("components.responses.FoundBookings", Matchers.notNullValue(), new Object[0]);
        vr.body("components.parameters.departureDate", Matchers.notNullValue(), new Object[0]);
        vr.body("components.parameters.username", Matchers.notNullValue(), new Object[0]);
        vr.body("components.examples.review", Matchers.notNullValue(), new Object[0]);
        vr.body("components.examples.user", Matchers.notNullValue(), new Object[0]);
        vr.body("components.requestBodies.review", Matchers.notNullValue(), new Object[0]);
        vr.body("components.headers.Max-Rate", Matchers.notNullValue(), new Object[0]);
        vr.body("components.headers.Request-Limit", Matchers.notNullValue(), new Object[0]);
        vr.body("components.securitySchemes.httpTestScheme", Matchers.notNullValue(), new Object[0]);
        vr.body("components.links.UserName", Matchers.notNullValue(), new Object[0]);
        vr.body("components.callbacks.GetBookings", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testHeaderInAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String responseHeader1 = "paths.'/reviews/{id}'.get.responses.'200'.headers.responseHeader1";
        vr.body(responseHeader1, Matchers.notNullValue(), new Object[0]);
        vr.body(responseHeader1 + ".description", Matchers.equalTo((Object)"Max rate"), new Object[0]);
        vr.body(responseHeader1 + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader1 + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader1 + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader1 + ".style", Matchers.equalTo((Object)"simple"), new Object[0]);
        vr.body(responseHeader1 + ".schema.type", Matchers.equalTo((Object)"integer"), new Object[0]);
        String responseHeader2 = "paths.'/reviews/{id}'.get.responses.'200'.headers.responseHeader2";
        vr.body(responseHeader2, Matchers.notNullValue(), new Object[0]);
        vr.body(responseHeader2 + ".description", Matchers.equalTo((Object)"Input value"), new Object[0]);
        vr.body(responseHeader2 + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader2 + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader2 + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(responseHeader2 + ".style", Matchers.equalTo((Object)"simple"), new Object[0]);
        vr.body(responseHeader2 + ".schema.type", Matchers.equalTo((Object)"string"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testHeaderInEncoding(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String testHeader = "paths.'/user'.post.requestBody.content.'application/json'.encoding.email.headers.testHeader";
        vr.body(testHeader, Matchers.notNullValue(), new Object[0]);
        vr.body(testHeader + ".description", Matchers.equalTo((Object)"Minimum rate"), new Object[0]);
        vr.body(testHeader + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(testHeader + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(testHeader + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(testHeader + ".style", Matchers.equalTo((Object)"simple"), new Object[0]);
        vr.body(testHeader + ".schema.type", Matchers.equalTo((Object)"integer"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testRefHeaderInAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String responseRefHeader = "paths.'/reviews'.get.responses.'200'.headers.Request-Limit";
        vr.body(responseRefHeader, Matchers.notNullValue(), new Object[0]);
        vr.body(responseRefHeader + ".$ref", Matchers.equalTo((Object)"#/components/headers/Request-Limit"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testRefHeaderInEncoding(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String encodingRefHeader = "paths.'/user/{username}'.put.responses.'200'.content.'application/json'.encoding.password.headers.Max-Rate";
        vr.body(encodingRefHeader, Matchers.notNullValue(), new Object[0]);
        vr.body(encodingRefHeader + ".$ref", Matchers.equalTo((Object)"#/components/headers/Max-Rate"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testHeaderInComponents(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String maxRate = "components.headers.Max-Rate";
        vr.body(maxRate + ".description", Matchers.equalTo((Object)"Maximum rate"), new Object[0]);
        vr.body(maxRate + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".style", Matchers.equalTo((Object)"simple"), new Object[0]);
        vr.body(maxRate + ".schema.type", Matchers.equalTo((Object)"integer"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContentInAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String content1 = "paths.'/availability'.get.responses.'200'.content.'application/json'";
        vr.body(content1, Matchers.notNullValue(), new Object[0]);
        vr.body(content1 + ".schema.type", Matchers.equalTo((Object)"array"), new Object[0]);
        vr.body(content1 + ".schema.items", Matchers.notNullValue(), new Object[0]);
        String content2 = "paths.'/user/{username}'.put.responses.'200'.content";
        vr.body(content2, Matchers.notNullValue(), new Object[0]);
        vr.body(content2 + ".'application/json'", Matchers.notNullValue(), new Object[0]);
        vr.body(content2 + ".'application/json'.schema.$ref", Matchers.equalTo((Object)"#/components/schemas/User"), new Object[0]);
        vr.body(content2 + ".'application/json'.encoding.password", Matchers.notNullValue(), new Object[0]);
        vr.body(content2, Matchers.notNullValue(), new Object[0]);
        vr.body(content2 + ".'application/xml'", Matchers.notNullValue(), new Object[0]);
        vr.body(content2 + ".'application/xml'.schema.$ref", Matchers.equalTo((Object)"#/components/schemas/User"), new Object[0]);
        vr.body(content2 + ".'application/xml'.encoding.password", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContentInRequestBody(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String contentJson = "paths.'/bookings'.post.requestBody.content.'application/json'";
        vr.body(contentJson, Matchers.notNullValue(), new Object[0]);
        vr.body(contentJson + ".schema.$ref", Matchers.equalTo((Object)"#/components/schemas/Booking"), new Object[0]);
        vr.body(contentJson + ".examples.booking.summary", Matchers.equalTo((Object)"External booking example"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContentInParameter(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String content = "paths.'/reviews/users/{user}'.get.parameters.find{ it.name == 'user' }.content";
        vr.body(content, Matchers.notNullValue(), new Object[0]);
        vr.body(content + ".'*/*'", Matchers.notNullValue(), new Object[0]);
        vr.body(content + ".'*/*'.schema.type", Matchers.equalTo((Object)"string"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testStaticFileDefinitions(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/streams'.post.description", Matchers.equalTo((Object)"subscribes a client to receive out-of-band data"), new Object[0]);
        String parametersPath = "paths.'/streams'.post.parameters";
        vr.body("paths.'/streams'.post.parameters", Matchers.hasSize((int)1), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.in", Matchers.equalTo((Object)"query"), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.description", Matchers.containsString((String)"the location where data will be sent."), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.schema.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.schema.format", Matchers.equalTo((Object)"uri"), new Object[0]);
        vr.body("paths.'/streams'.post.parameters.find{ it.name == 'callbackUrl' }.schema.example", Matchers.equalTo((Object)"https://tonys-server.com"), new Object[0]);
        String responsePath = "paths.'/streams'.post.responses";
        vr.body("paths.'/streams'.post.responses", IsMapWithSize.aMapWithSize((int)1), new Object[0]);
        String response201Path = "paths.'/streams'.post.responses.'201'";
        vr.body("paths.'/streams'.post.responses.'201'.description", Matchers.equalTo((Object)"subscription successfully created"), new Object[0]);
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.description", Matchers.equalTo((Object)"subscription information"), new Object[0]);
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"subscriptionId"})), new Object[0]);
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.properties.subscriptionId.description", Matchers.equalTo((Object)"this unique identifier allows management of the subscription"), new Object[0]);
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.properties.subscriptionId.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("paths.'/streams'.post.responses.'201'.content.'application/json'.schema.properties.subscriptionId.example", Matchers.equalTo((Object)"2531329f-fb09-4ef7-887e-84e648214436"), new Object[0]);
        String callbacksPath = "paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post";
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.requestBody.description", Matchers.equalTo((Object)"subscription payload"), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.requestBody.content.'application/json'.schema.properties.timestamp.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.requestBody.content.'application/json'.schema.properties.timestamp.format", Matchers.equalTo((Object)"date-time"), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.requestBody.content.'application/json'.schema.properties.userData.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.responses.'202'.description", (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"Your server implementation should return this HTTP status code")).and(Matchers.containsString((String)"if the data was received successfully")), new Object[0]);
        vr.body("paths.'/streams'.post.callbacks.onData.'{$request.query.callbackUrl}/data'.post.responses.'204'.description", (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"Your server should return this HTTP status code if no longer interested")).and(Matchers.containsString((String)"in further updates")), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExtensionParsing(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/'.get.'x-string-property'", Matchers.equalTo((Object)"string-value"), new Object[0]);
        vr.body("paths.'/'.get.'x-boolean-property'", Matchers.equalTo((Object)Boolean.TRUE), new Object[0]);
        vr.body("paths.'/'.get.'x-number-property'", Matchers.equalTo((Object)117), new Object[0]);
        vr.body("paths.'/'.get.'x-object-property'.'property-1'", Matchers.equalTo((Object)"value-1"), new Object[0]);
        vr.body("paths.'/'.get.'x-object-property'.'property-3'.'prop-3-1'", Matchers.equalTo((Object)17), new Object[0]);
        vr.body("paths.'/'.get.'x-string-array-property'[1]", Matchers.equalTo((Object)"two"), new Object[0]);
        vr.body("paths.'/'.get.'x-object-array-property'[1].name", Matchers.equalTo((Object)"item-2"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExceptionMappers(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/user/{id}'.get.responses.'404'.description", Matchers.equalTo((Object)"Not Found"), new Object[0]);
        vr.body("paths.'/user/{username}'.get.responses.'404'.description", Matchers.equalTo((Object)"Not Found"), new Object[0]);
        vr.body("paths.'/user/{id}'.get.responses.'404'.content.'application/json'.schema", Matchers.notNullValue(), new Object[0]);
    }
}

