/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.openapi.tck;

import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import org.eclipse.microprofile.openapi.tck.AppTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapWithSize;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class ModelReaderAppTest
extends AppTestBase {
    @Deployment(name="airlinesModelReader")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"airlinesReader.war")).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.apps.airlines"})).addPackages(true, new String[]{"org.eclipse.microprofile.openapi.reader"})).addAsManifestResource("microprofile-reader.properties", "microprofile-config.properties");
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testVersion(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("openapi", Matchers.startsWith((String)"3.0."), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testInfo(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.title", Matchers.equalTo((Object)"AirlinesRatingApp API"), new Object[0]);
        vr.body("info.version", Matchers.equalTo((Object)"1.0"), new Object[0]);
        vr.body("info.termsOfService", Matchers.equalTo((Object)"http://airlinesratingapp.com/terms"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContact(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.contact.name", Matchers.equalTo((Object)"AirlinesRatingApp API Support"), new Object[0]);
        vr.body("info.contact.url", Matchers.equalTo((Object)"http://exampleurl.com/contact"), new Object[0]);
        vr.body("info.contact.email", Matchers.equalTo((Object)"techsupport@airlinesratingapp.com"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testLicense(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("info.license.name", Matchers.equalTo((Object)"Apache 2.0"), new Object[0]);
        vr.body("info.license.url", Matchers.equalTo((Object)"http://www.apache.org/licenses/LICENSE-2.0.html"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExternalDocumentation(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("externalDocs.description", Matchers.equalTo((Object)"instructions for how to deploy this app"), new Object[0]);
        vr.body("externalDocs.url", Matchers.containsString((String)"README.md"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testServer(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("servers", Matchers.hasSize((int)2), new Object[0]);
        vr.body("servers.url", Matchers.hasSize((int)2), new Object[0]);
        String url = "https://{username}.gigantic-server.com:{port}/{basePath}";
        String serverPath = "servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"The production API server"), new Object[0]);
        vr.body(serverPath + ".variables", IsMapWithSize.aMapWithSize((int)4), new Object[0]);
        vr.body(serverPath + ".variables.username.description", Matchers.equalTo((Object)"Reviews of the app by users"), new Object[0]);
        vr.body(serverPath + ".variables.username.default", Matchers.equalTo((Object)"user1"), new Object[0]);
        vr.body(serverPath + ".variables.username.enum", Matchers.containsInAnyOrder((Object[])new String[]{"user1", "user2"}), new Object[0]);
        vr.body(serverPath + ".variables.port.description", Matchers.equalTo((Object)"Booking data"), new Object[0]);
        vr.body(serverPath + ".variables.port.default", Matchers.equalTo((Object)"8443"), new Object[0]);
        vr.body(serverPath + ".variables.user.description", Matchers.equalTo((Object)"User data"), new Object[0]);
        vr.body(serverPath + ".variables.user.default", Matchers.equalTo((Object)"user"), new Object[0]);
        vr.body(serverPath + ".variables.basePath.default", Matchers.equalTo((Object)"v2"), new Object[0]);
        url = "https://test-server.com:80/basePath";
        serverPath = "servers.find { it.url == '" + url + "' }";
        vr.body(serverPath + ".description", Matchers.equalTo((Object)"The test API server"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationAirlinesResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/modelReader/airlines'.get.summary", Matchers.equalTo((Object)"Retrieve all available airlines"), new Object[0]);
        vr.body("paths.'/modelReader/airlines'.get.operationId", Matchers.equalTo((Object)"getAirlines"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationAvailabilityResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.summary", Matchers.equalTo((Object)"Retrieve all available flights"), new Object[0]);
        vr.body("paths.'/availability'.get.operationId", Matchers.equalTo((Object)"getFlights"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testOperationBookingResource(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/modelReader/bookings'.get.summary", Matchers.equalTo((Object)"Retrieve all bookings for current user"), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.get.operationId", Matchers.equalTo((Object)"getAllBookings"), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.post.summary", Matchers.equalTo((Object)"Create a booking"), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.post.description", Matchers.equalTo((Object)"Create a new booking record with the booking information provided."), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.post.operationId", Matchers.equalTo((Object)"createBooking"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.responses", IsMapWithSize.aMapWithSize((int)2), new Object[0]);
        vr.body("paths.'/availability'.get.responses.'200'.description", Matchers.equalTo((Object)"successful operation"), new Object[0]);
        vr.body("paths.'/availability'.get.responses.'404'.description", Matchers.equalTo((Object)"No available flights found"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testAvailabilityGetParameter(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String availabilityParameters = "paths.'/availabilityModel'.get.parameters";
        vr.body(availabilityParameters, Matchers.hasSize((int)6), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it }.name", Matchers.hasItems((Object[])new String[]{"airportFrom", "returningDate", "airportTo", "numberOfAdults", "numberOfChildren"}), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it.$ref == '#/components/parameters/departureDate'}", Matchers.notNullValue(), new Object[0]);
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{"airportFrom", "Airport the customer departs from"});
        list.add(new String[]{"returningDate", "Customer return date"});
        list.add(new String[]{"airportTo", "Airport the customer returns to"});
        list.add(new String[]{"numberOfAdults", "Number of adults on the flight"});
        list.add(new String[]{"numberOfChildren", "Number of children on the flight"});
        for (int i = 0; i < list.size(); ++i) {
            String currentParam = ((String[])list.get(i))[0];
            String query = availabilityParameters + ".findAll { it.name == '" + currentParam + "' }";
            vr.body(query + ".in", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"query"})), new Object[0]);
            vr.body(query + ".description", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{((String[])list.get(i))[1]})), new Object[0]);
            vr.body(query + ".required", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{true})), new Object[0]);
            vr.body(query + ".schema.type", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{"string"})), new Object[0]);
        }
        vr.body(availabilityParameters + ".findAll { it.name == 'numberOfAdults' }.schema.minimum", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{0})), new Object[0]);
        vr.body(availabilityParameters + ".findAll { it.name == 'numberOfChildren' }.schema.minimum", (Matcher)Matchers.both((Matcher)Matchers.hasSize((int)1)).and(Matchers.contains((Object[])new Object[]{0})), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecurityRequirement(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0][0]", Matchers.equalTo((Object)"write:bookings"), new Object[0]);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0][1]", Matchers.equalTo((Object)"read:bookings"), new Object[0]);
        vr.body("paths.'/reviews'.post.security.bookingSecurityScheme", Matchers.hasSize((int)1), new Object[0]);
        vr.body("paths.'/bookings'.post.security.bookingSecurityScheme[0]", Matchers.hasSize((int)2), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecuritySchemes(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String s = "components.securitySchemes";
        vr.body(s, Matchers.hasKey((Object)"httpTestScheme"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSecurityScheme(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String http = "components.securitySchemes.httpTestScheme.";
        vr.body(http + "type", Matchers.equalTo((Object)"http"), new Object[0]);
        vr.body(http + "description", Matchers.equalTo((Object)"user security scheme"), new Object[0]);
        vr.body(http + "scheme", Matchers.equalTo((Object)"testScheme"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testSchema(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.AirlinesRef.$ref", Matchers.equalTo((Object)"#/components/schemas/Airlines"), new Object[0]);
        vr.body("components.schemas.Airlines.title", Matchers.equalTo((Object)"Airlines"), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.post.responses.'201'.content.'text/plain'.schema.type", Matchers.equalTo((Object)"string"), new Object[0]);
        vr.body("components.schemas.id.format", Matchers.equalTo((Object)"int32"), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.post.responses.'201'.content.'text/plain'.schema.description", Matchers.equalTo((Object)"id of the new booking"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testExampleObject(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.examples.review.summary", Matchers.equalTo((Object)"External review example"), new Object[0]);
        vr.body("components.examples.review.description", Matchers.equalTo((Object)"This example exemplifies the content on our site."), new Object[0]);
        vr.body("components.examples.review.externalValue", Matchers.equalTo((Object)"http://foo.bar/examples/review-example.json"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testTagDeclarations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String tagsPath = "tags.find { it.name == '";
        String desc = "' }.description";
        vr.body(tagsPath + "user" + desc, Matchers.equalTo((Object)"Operations about user"), new Object[0]);
        vr.body(tagsPath + "create" + desc, Matchers.equalTo((Object)"Operations about create"), new Object[0]);
        vr.body(tagsPath + "Airlines" + desc, Matchers.equalTo((Object)"All the airlines methods"), new Object[0]);
        vr.body(tagsPath + "Availability" + desc, Matchers.equalTo((Object)"All the availability methods"), new Object[0]);
        vr.body(tagsPath + "Get Flights" + desc, Matchers.equalTo((Object)"method to retrieve all flights available"), new Object[0]);
        vr.body(tagsPath + "Get Flights' }.externalDocs.description", Matchers.equalTo((Object)"A list of all the flights offered by the app"), new Object[0]);
        vr.body(tagsPath + "Get Flights' }.externalDocs.url", Matchers.equalTo((Object)"http://airlinesratingapp.com/ourflights"), new Object[0]);
        vr.body(tagsPath + "Bookings" + desc, Matchers.equalTo((Object)"All the bookings methods"), new Object[0]);
        vr.body(tagsPath + "Get Airlines" + desc, Matchers.equalTo((Object)"method to get all airlines"), new Object[0]);
        vr.body(tagsPath + "Retrieve Airlines" + desc, Matchers.equalTo((Object)"method to retrieve all airlines"), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testTagsInOperations(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("paths.'/availability'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"Get Flights", "Availability"}), new Object[0]);
        vr.body("paths.'/modelReader/bookings'.get.tags", Matchers.containsInAnyOrder((Object[])new String[]{"bookings"}), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testComponents(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        vr.body("components.schemas.Bookings", Matchers.notNullValue(), new Object[0]);
        vr.body("components.schemas.Airlines", Matchers.notNullValue(), new Object[0]);
        vr.body("components.schemas.AirlinesRef", Matchers.notNullValue(), new Object[0]);
        vr.body("components.responses.FoundAirlines", Matchers.notNullValue(), new Object[0]);
        vr.body("components.responses.FoundBookings", Matchers.notNullValue(), new Object[0]);
        vr.body("components.parameters.departureDate", Matchers.notNullValue(), new Object[0]);
        vr.body("components.parameters.username", Matchers.notNullValue(), new Object[0]);
        vr.body("components.examples.review", Matchers.notNullValue(), new Object[0]);
        vr.body("components.examples.user", Matchers.notNullValue(), new Object[0]);
        vr.body("components.requestBodies.review", Matchers.notNullValue(), new Object[0]);
        vr.body("components.headers.Max-Rate", Matchers.notNullValue(), new Object[0]);
        vr.body("components.headers.Request-Limit", Matchers.notNullValue(), new Object[0]);
        vr.body("components.securitySchemes.httpTestScheme", Matchers.notNullValue(), new Object[0]);
        vr.body("components.links.UserName", Matchers.notNullValue(), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testHeaderInComponents(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String maxRate = "components.headers.Max-Rate";
        vr.body(maxRate + ".description", Matchers.equalTo((Object)"Maximum rate"), new Object[0]);
        vr.body(maxRate + ".required", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".deprecated", Matchers.equalTo((Object)true), new Object[0]);
        vr.body(maxRate + ".allowEmptyValue", Matchers.equalTo((Object)true), new Object[0]);
    }

    @RunAsClient
    @Test(dataProvider="formatProvider")
    public void testContentInAPIResponse(String type) {
        ValidatableResponse vr = this.callEndpoint(type);
        String content1 = "paths.'/availability'.get.responses.'200'.content.'application/json'";
        vr.body(content1, Matchers.notNullValue(), new Object[0]);
        vr.body(content1 + ".schema.type", Matchers.equalTo((Object)"array"), new Object[0]);
        vr.body(content1 + ".schema.items", Matchers.notNullValue(), new Object[0]);
    }
}

