/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.AbstractCDOViewProvider;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderRegistry;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.view.PluginContainerViewProvider;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.om.OMPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOViewProviderRegistryImpl
extends Container<CDOViewProvider>
implements CDOViewProviderRegistry {
    public static final CDOViewProviderRegistryImpl INSTANCE = new CDOViewProviderRegistryImpl();
    private static final String EXT_POINT = "viewProviders";
    private List<CDOViewProvider> viewProviders = new ArrayList<CDOViewProvider>();

    public CDOViewProviderRegistryImpl() {
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            this.addViewProvider(new PluginContainerViewProvider());
        }
    }

    @Override
    public CDOView provideView(URI uri, ResourceSet resourceSet) {
        if (uri == null) {
            return null;
        }
        CDOViewSet viewSet = CDOUtil.getViewSet(resourceSet);
        if (viewSet != null) {
            try {
                String uuid = CDOURIUtil.extractRepositoryUUID(uri);
                CDOView view = viewSet.resolveView(uuid);
                if (view != null) {
                    return view;
                }
            }
            catch (Exception exception) {}
        }
        CDOViewProvider[] cDOViewProviderArray = this.getViewProviders(uri);
        int n = cDOViewProviderArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOViewProvider viewProvider = cDOViewProviderArray[n2];
            CDOView view = viewProvider.getView(uri, resourceSet);
            if (view != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public CDOViewProvider[] getViewProviders(URI uri) {
        ArrayList<CDOViewProvider> result = new ArrayList<CDOViewProvider>();
        for (CDOViewProvider viewProvider : this.viewProviders) {
            if (!viewProvider.matchesRegex(uri)) continue;
            result.add(viewProvider);
        }
        Collections.sort(result, new Comparator<CDOViewProvider>(){

            @Override
            public int compare(CDOViewProvider o1, CDOViewProvider o2) {
                return -new Integer(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        return result.toArray(new CDOViewProvider[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addViewProvider(CDOViewProvider viewProvider) {
        boolean added;
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            boolean bl = added = !this.viewProviders.contains(viewProvider);
            if (added) {
                this.viewProviders.add(viewProvider);
            }
        }
        if (added) {
            this.fireElementAddedEvent(viewProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeViewProvider(CDOViewProvider viewProvider) {
        boolean removed;
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            removed = this.viewProviders.remove(viewProvider);
        }
        if (removed) {
            this.fireElementRemovedEvent(viewProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOViewProvider[] getElements() {
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            return this.viewProviders.toArray(new CDOViewProvider[this.viewProviders.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List<CDOViewProvider> list = this.viewProviders;
        synchronized (list) {
            return this.viewProviders.isEmpty();
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        if (OMPlatform.INSTANCE.isOSGiRunning()) {
            try {
                this.readExtensions();
            }
            catch (Throwable t) {
                OM.LOG.error(t);
            }
        }
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
    }

    public void readExtensions() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo", EXT_POINT);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                CDOViewProviderDescriptor descriptor = new CDOViewProviderDescriptor(element);
                this.addViewProvider(descriptor);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public static final class CDOViewProviderDescriptor
    extends AbstractCDOViewProvider {
        private IConfigurationElement element;

        public CDOViewProviderDescriptor(IConfigurationElement element) {
            super(element.getAttribute("regex"), Integer.parseInt(element.getAttribute("priority")));
            this.element = element;
            if (StringUtil.isEmpty((String)element.getAttribute("class"))) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewProviderRegistryImpl.4"), element));
            }
            if (StringUtil.isEmpty((String)element.getAttribute("regex"))) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewProviderRegistryImpl.6"), element));
            }
        }

        public CDOView getView(URI uri, ResourceSet resourceSet) {
            return this.getViewProvider().getView(uri, resourceSet);
        }

        private CDOViewProvider getViewProvider() {
            try {
                return (CDOViewProvider)this.element.createExecutableExtension("class");
            }
            catch (CoreException ex) {
                throw WrappedException.wrap((Exception)((Object)ex));
            }
        }
    }
}

