/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.RTSource;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTSetup
implements RTSource {
    private static int ourURISuffix = 1;
    protected Diagram myCanvas;
    private Node myNodeA;
    private Node myNodeB;
    private Edge myLinkByClass;
    private Edge myLinkByRef;
    private Node myNodeACompartment;
    private Node myNodeBCompartment;
    protected EObject myDiagramElement;

    public final RTSetup init(Bundle b, DiaGenSource genSource) {
        return this.init(b, genSource, null);
    }

    public final RTSetup init(Bundle b, DiaGenSource genSource, TransactionalEditingDomain domain) {
        return this.init(new CoolDomainInstanceProducer(b), genSource, domain);
    }

    public final RTSetup init(DiaGenSource genSource) {
        return this.init(genSource, null);
    }

    public final RTSetup init(DiaGenSource genSource, TransactionalEditingDomain domain) {
        return this.init(new NaiveDomainInstanceProducer(), genSource, domain);
    }

    private RTSetup init(DomainInstanceProducer producer, DiaGenSource genSource, TransactionalEditingDomain domain) {
        this.initDiagramFileContents(producer, genSource);
        this.saveDiagramFile(domain, genSource.getGenDiagram().getEditingDomainID());
        return this;
    }

    protected void initDiagramFileContents(DomainInstanceProducer instanceProducer, DiaGenSource genSource) {
        this.myCanvas = NotationFactory.eINSTANCE.createDiagram();
        this.myDiagramElement = instanceProducer.createInstance(genSource.getGenDiagram().getDomainDiagramElement());
        this.myCanvas.setElement(this.myDiagramElement);
        this.myCanvas.setType(genSource.getGenDiagram().getEditorGen().getModelID());
        this.myNodeA = this.setupNotationNode(genSource.getNodeA(), instanceProducer);
        List<Node> compartments = this.setupNotationCompartments(this.myNodeA, genSource.getNodeA());
        if (compartments.size() > 0) {
            this.myNodeACompartment = compartments.get(0);
        }
        this.myNodeB = this.setupNotationNode(genSource.getNodeB(), instanceProducer);
        compartments = this.setupNotationCompartments(this.myNodeB, genSource.getNodeB());
        if (compartments.size() > 0) {
            this.myNodeBCompartment = compartments.get(0);
        }
        this.myLinkByClass = NotationFactory.eINSTANCE.createEdge();
        this.myCanvas.getPersistedEdges().add((Object)this.myLinkByClass);
        TypeLinkModelFacet byClassFacet = (TypeLinkModelFacet)genSource.getLinkC().getModelFacet();
        EObject linkElement = instanceProducer.createInstance(byClassFacet.getMetaClass());
        instanceProducer.setFeatureValue(this.myNodeA.getElement(), linkElement, byClassFacet.getContainmentMetaFeature());
        instanceProducer.setFeatureValue(linkElement, this.myNodeB.getElement(), byClassFacet.getTargetMetaFeature());
        this.myLinkByClass.setElement(linkElement);
        this.myLinkByClass.setType(String.valueOf(genSource.getLinkC().getVisualID()));
        this.myLinkByClass.setSource((View)this.myNodeA);
        this.myLinkByClass.setTarget((View)this.myNodeB);
        this.setBendpoints(this.myLinkByClass);
        FeatureLinkModelFacet byRefFacet = (FeatureLinkModelFacet)genSource.getLinkD().getModelFacet();
        Assert.assertNotNull((Object)byRefFacet);
        EStructuralFeature metaFeature = byRefFacet.getMetaFeature().getEcoreFeature();
        this.myLinkByRef = NotationFactory.eINSTANCE.createEdge();
        if (this.myNodeA.getElement().eClass().getEStructuralFeature(metaFeature.getName()) != null) {
            instanceProducer.setFeatureValue(this.myNodeA.getElement(), this.myNodeB.getElement(), byRefFacet.getMetaFeature());
            this.myLinkByRef.setSource((View)this.myNodeA);
            this.myLinkByRef.setTarget((View)this.myNodeB);
        } else if (this.myNodeB.getElement().eClass().getEStructuralFeature(metaFeature.getName()) != null) {
            instanceProducer.setFeatureValue(this.myNodeB.getElement(), this.myNodeA.getElement(), byRefFacet.getMetaFeature());
            this.myLinkByRef.setSource((View)this.myNodeB);
            this.myLinkByRef.setTarget((View)this.myNodeA);
        }
        this.myCanvas.getPersistedEdges().add((Object)this.myLinkByRef);
        this.myLinkByRef.setType(String.valueOf(genSource.getLinkD().getVisualID()));
        this.myLinkByRef.setElement(null);
        this.setBendpoints(this.myLinkByRef);
    }

    private void setBendpoints(Edge edge) {
        edge.setBendpoints((Bendpoints)NotationFactory.eINSTANCE.createRelativeBendpoints());
    }

    private Node setupNotationNode(GenNode genNode, DomainInstanceProducer instanceProducer) {
        Node result = NotationFactory.eINSTANCE.createNode();
        this.myCanvas.getPersistedChildren().add((Object)result);
        EObject nodeElement = instanceProducer.createInstance(genNode.getDomainMetaClass());
        instanceProducer.setFeatureValue(this.myDiagramElement, nodeElement, genNode.getModelFacet().getContainmentMetaFeature());
        result.setElement(nodeElement);
        result.setType(String.valueOf(genNode.getVisualID()));
        result.getStyles().add((Object)NotationFactory.eINSTANCE.createShapeStyle());
        Bounds b = NotationFactory.eINSTANCE.createBounds();
        b.setWidth(0);
        b.setHeight(0);
        result.setLayoutConstraint((LayoutConstraint)b);
        return result;
    }

    private List<Node> setupNotationCompartments(Node notationParent, GenNode genParent) {
        LinkedList<Node> compartments = new LinkedList<Node>();
        for (GenCompartment nextCompartment : genParent.getCompartments()) {
            Node notationCompartment = NotationFactory.eINSTANCE.createNode();
            notationCompartment.setType(String.valueOf(nextCompartment.getVisualID()));
            notationParent.getTransientChildren().add((Object)notationCompartment);
            Assert.assertTrue((boolean)notationParent.getChildren().contains((Object)notationCompartment));
            compartments.add(notationCompartment);
        }
        return compartments;
    }

    private void saveDiagramFile(TransactionalEditingDomain ted, String editingDomainId) {
        URI uri;
        ResourceSet rs;
        Resource r;
        if (ted == null) {
            ted = DiagramEditingDomainFactory.getInstance().createEditingDomain();
            ted.setID(editingDomainId);
            ((AdapterFactoryEditingDomain)ted).setResourceToReadOnlyMap((Map)new HashMap<Resource, Boolean>(){

                @Override
                public Boolean get(Object key) {
                    if (key instanceof Resource && "uri".equals(((Resource)key).getURI().scheme())) {
                        return Boolean.FALSE;
                    }
                    return (Boolean)super.get(key);
                }
            });
        }
        if ((r = (rs = ted.getResourceSet()).getResource(uri = URI.createURI((String)("uri://fake/z" + ourURISuffix++)), false)) == null) {
            r = rs.createResource(uri);
        }
        final Resource diagramFile = r;
        AbstractEMFOperation operation = new AbstractEMFOperation(ted, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                diagramFile.getContents().clear();
                diagramFile.getContents().add((Object)RTSetup.this.getCanvas());
                diagramFile.getContents().add((Object)RTSetup.this.getDiagramElement());
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            Assert.fail((String)"Failed to set diagram resource contents");
        }
    }

    @Override
    public final Diagram getCanvas() {
        return this.myCanvas;
    }

    @Override
    public final Node getNodeA() {
        return this.myNodeA;
    }

    @Override
    public final Node getNodeB() {
        return this.myNodeB;
    }

    @Override
    public Node getNodeACompartment() {
        Assert.assertNotNull((String)"No compartment for Node A in this genmodel", (Object)this.myNodeACompartment);
        return this.myNodeACompartment;
    }

    @Override
    public Node getNodeBCompartment() {
        Assert.assertNotNull((String)"No compartment for Node B in this genmodel", (Object)this.myNodeBCompartment);
        return this.myNodeBCompartment;
    }

    @Override
    public Edge getLinkByClass() {
        return this.myLinkByClass;
    }

    @Override
    public Edge getLinkByRef() {
        return this.myLinkByRef;
    }

    protected EObject getDiagramElement() {
        return this.myDiagramElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CoolDomainInstanceProducer
    implements DomainInstanceProducer {
        private final Bundle bundle;

        @Override
        public EObject createInstance(GenClass genClass) {
            try {
                Class<?> factoryClass = this.getFactoryClass(genClass);
                Method m = factoryClass.getMethod("create" + genClass.getName(), new Class[0]);
                return (EObject)m.invoke(this.getInstance(factoryClass), new Object[0]);
            }
            catch (Exception ex) {
                Assert.fail((String)(String.valueOf(ex.getClass().getSimpleName()) + ":" + ex.getMessage()));
                Assert.fail();
                return null;
            }
        }

        @Override
        public void setFeatureValue(EObject src, EObject value, GenFeature genFeature) {
            try {
                Class<?> packageClass = this.getPackageClass(genFeature);
                Method featureAccessor = packageClass.getMethod("get" + genFeature.getFeatureAccessorName(), new Class[0]);
                EStructuralFeature feature = (EStructuralFeature)featureAccessor.invoke(this.getInstance(packageClass), new Object[0]);
                if (genFeature.isListType()) {
                    Collection result = (Collection)src.eGet(feature);
                    result.add(value);
                } else {
                    src.eSet(feature, (Object)value);
                }
            }
            catch (Exception ex) {
                Assert.fail((String)(String.valueOf(ex.getClass().getSimpleName()) + ":" + ex.getMessage()));
            }
        }

        private Class<?> getFactoryClass(GenClass genClass) throws ClassNotFoundException {
            return this.bundle.loadClass(genClass.getGenPackage().getQualifiedFactoryInterfaceName());
        }

        private Object getInstance(Class<?> interfaceClass) throws NoSuchFieldException, IllegalAccessException {
            return interfaceClass.getField("eINSTANCE").get(null);
        }

        private Class<?> getPackageClass(GenFeature genFeature) throws ClassNotFoundException {
            return this.bundle.loadClass(genFeature.getGenPackage().getQualifiedPackageInterfaceName());
        }

        public CoolDomainInstanceProducer(Bundle b) {
            this.bundle = b;
        }
    }

    protected static interface DomainInstanceProducer {
        public EObject createInstance(GenClass var1);

        public void setFeatureValue(EObject var1, EObject var2, GenFeature var3);
    }

    private static class NaiveDomainInstanceProducer
    implements DomainInstanceProducer {
        private NaiveDomainInstanceProducer() {
        }

        public EObject createInstance(GenClass genClass) {
            return this.createInstance(genClass.getEcoreClass());
        }

        public void setFeatureValue(EObject src, EObject value, GenFeature genFeature) {
            EStructuralFeature feature = genFeature.getEcoreFeature();
            if (genFeature.isListType()) {
                Collection result = (Collection)src.eGet(feature);
                result.add(value);
            } else {
                src.eSet(feature, (Object)value);
            }
        }

        public EObject createInstance(EClass eClass) {
            return eClass.getEPackage().getEFactoryInstance().create(eClass);
        }
    }
}

