/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.compiler.IJETCompilerState;
import org.eclipse.jet.compiler.JET2Compiler;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.SavedStateManager;
import org.eclipse.jet.internal.compiler.JETCompilerState;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.osgi.util.NLS;

public class JET2Builder
extends IncrementalProjectBuilder
implements SavedStateManager.IStateSaver {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/builder")) != false;
    static final String COMPILESTATE_PROJECT_DIR = "projects";
    private int filesToCompileCount;
    private JETCompilerState compilerState;
    private final SavedStateManager savedStateManager = InternalJET2Platform.getDefault().getSavedStateManager();

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: cleaning " + this.getProject());
        }
        JET2Compiler compiler = this.getJETCompiler((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        compiler.clean();
        this.compilerState.clear();
        if (DEBUG) {
            System.out.println("*JET2Builder: done cleaning " + this.getProject());
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: build(" + this.getProject() + ", " + kind + ")");
        }
        try {
            if (kind == 15) {
                this.compilerState.clear();
            } else if (kind == 6) {
                this.clean((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.fullBuild((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (this.isReferencedProjectChanged() || delta == null) {
                    this.clean((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.fullBuild((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
            IProject[] iProjectArray = this.computeReferencedProjects(this.compilerState);
            Object var5_6 = null;
            if (DEBUG) {
                System.out.println("JET2Builder: done build(" + this.getProject() + ", " + kind + ")");
            }
            return iProjectArray;
        }
        catch (Throwable throwable) {
            block10: {
                Object var5_7 = null;
                if (!DEBUG) break block10;
                System.out.println("JET2Builder: done build(" + this.getProject() + ", " + kind + ")");
            }
            throw throwable;
        }
    }

    private boolean isReferencedProjectChanged() {
        IProject[] projects = this.computeReferencedProjects(this.compilerState);
        int i = 0;
        while (i < projects.length) {
            IResourceDelta delta = this.getDelta(projects[i]);
            if (delta != null && (delta.findMember((IPath)new Path("plugin.xml")) != null || delta.findMember((IPath)new Path("META-INF/MANIFEST.MF")) != null)) {
                if (DEBUG) {
                    System.out.println("   forcing full build. ref updated:" + projects[i]);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void incrementalBuild(IResourceDelta mainDelta, final IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: incrementalBuild " + this.getProject());
        }
        this.compilerState.setProjectTagLibraryReferences(JET2Platform.getProjectDescription(this.getProject().getName()).getTagLibraryReferences());
        final JET2Compiler compiler = this.getJETCompiler(monitor);
        this.filesToCompileCount = 0;
        mainDelta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                switch (delta.getKind()) {
                    case 1: 
                    case 2: 
                    case 4: {
                        if (!compiler.isJET2SourceFile(delta.getResource())) break;
                        JET2Builder jET2Builder = JET2Builder.this;
                        jET2Builder.filesToCompileCount = jET2Builder.filesToCompileCount + 1;
                    }
                }
                return true;
            }
        });
        monitor.beginTask(NLS.bind((String)JET2Messages.JET2Builder_CompilingChanged, (Object)this.getProject().getName()), this.filesToCompileCount);
        try {
            try {
                mainDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        switch (delta.getKind()) {
                            case 1: 
                            case 4: {
                                if (DEBUG) {
                                    System.out.println("JET2Builder: add/change " + resource);
                                }
                                if (resource.getType() == 1 && JET2Builder.this.getProject().equals((Object)resource.getProject())) {
                                    monitor.subTask(NLS.bind((String)JET2Messages.JET2Builder_Compiling, (Object)resource.getProjectRelativePath()));
                                    compiler.compile(resource);
                                }
                                monitor.worked(1);
                                break;
                            }
                            case 2: {
                                if (DEBUG) {
                                    System.out.println("JET2Builder remove " + resource);
                                }
                                monitor.subTask(NLS.bind((String)JET2Messages.JET2Builder_Cleaning, (Object)resource.getProjectRelativePath()));
                                if (resource.getType() == 1 && JET2Builder.this.getProject().equals((Object)resource.getProject())) {
                                    compiler.removeDerivedResources(resource, false);
                                    JET2Builder.this.compilerState.removeTemplate(resource.getProjectRelativePath().toString());
                                }
                                monitor.worked(1);
                            }
                        }
                        return true;
                    }
                });
                compiler.createTransformFiles();
            }
            catch (CoreException e) {
                this.compilerState.clear();
                this.forgetLastBuiltState();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            if (!DEBUG) throw throwable;
            System.out.println("JET2Builder: done incrementalBuild " + this.getProject());
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        if (!DEBUG) return;
        System.out.println("JET2Builder: done incrementalBuild " + this.getProject());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fullBuild(final IProgressMonitor monitor) throws CoreException {
        if (DEBUG) {
            System.out.println("JET2Builder: fullBuild " + this.getProject());
        }
        this.compilerState.setProjectTagLibraryReferences(JET2Platform.getProjectDescription(this.getProject().getName()).getTagLibraryReferences());
        final JET2Compiler compiler = this.getJETCompiler(monitor);
        this.filesToCompileCount = 0;
        this.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (compiler.isJET2SourceFile(resource)) {
                    JET2Builder jET2Builder = JET2Builder.this;
                    jET2Builder.filesToCompileCount = jET2Builder.filesToCompileCount + 1;
                }
                return true;
            }
        });
        monitor.beginTask(NLS.bind((String)JET2Messages.JET2Builder_CompilingAll, (Object)this.getProject().getName()), this.filesToCompileCount);
        try {
            try {
                this.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        monitor.subTask(NLS.bind((String)JET2Messages.JET2Builder_Compiling, (Object)resource.getProjectRelativePath()));
                        compiler.compile(resource);
                        monitor.worked(1);
                        return true;
                    }
                });
                compiler.createTransformFiles();
            }
            catch (CoreException e) {
                this.compilerState.clear();
                this.forgetLastBuiltState();
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            if (!DEBUG) throw throwable;
            System.out.println("JET2Builder: done fullBuild " + this.getProject());
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        if (!DEBUG) return;
        System.out.println("JET2Builder: done fullBuild " + this.getProject());
    }

    private JET2Compiler getJETCompiler(IProgressMonitor monitor) {
        JET2Compiler compiler = new JET2Compiler(this.getProject(), CompileOptionsManager.getOptions(this.getProject()), this.compilerState, monitor);
        return compiler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startupOnInitialize() {
        block17: {
            super.startupOnInitialize();
            this.compilerState = null;
            if (DEBUG) {
                System.out.println("JET2Builder: startupOnInitialize " + this.getProject());
            }
            try {
                IPath fileLocation = this.savedStateManager.addSaveSaver(this, this.getProject());
                if (fileLocation != null) {
                    File savedStateFile = fileLocation.toFile();
                    try {
                        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(savedStateFile));
                        this.compilerState = (JETCompilerState)ois.readObject();
                        ois.close();
                        if (DEBUG) {
                            System.out.println("    loaded compilerState from saved state");
                            System.out.print("         taglibs   : [");
                            String[] ids = this.compilerState.getAllReferencedTagLibraryIds();
                            int i = 0;
                            while (true) {
                                if (i >= ids.length) {
                                    System.out.println("]");
                                    System.out.println("         templates : " + this.compilerState.getTemplateMap());
                                }
                                if (i != 0) {
                                    System.out.print(", ");
                                }
                                System.out.print(ids[i]);
                                ++i;
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException e) {
                        JETActivatorWrapper.INSTANCE.log(e);
                        savedStateFile.delete();
                    }
                    catch (ClassNotFoundException e) {
                        InternalJET2Platform.logError("Could not deserialize JET2Builder State", e);
                    }
                }
                Object var6_10 = null;
                if (this.compilerState != null) break block17;
                if (DEBUG) {
                    System.out.println("    compilerState not loaded from saved state");
                }
                this.compilerState = new JETCompilerState();
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (this.compilerState == null) {
                    if (DEBUG) {
                        System.out.println("    compilerState not loaded from saved state");
                    }
                    this.compilerState = new JETCompilerState();
                    this.forgetLastBuiltState();
                }
                if (!DEBUG) throw throwable;
                System.out.println("JET2Builder: done startupOnInitialize " + this.getProject());
                throw throwable;
            }
            this.forgetLastBuiltState();
        }
        if (!DEBUG) return;
        System.out.println("JET2Builder: done startupOnInitialize " + this.getProject());
    }

    private IProject[] computeReferencedProjects(IJETCompilerState compilerState) {
        String[] allReferencedTagLibraryIds = compilerState.getAllReferencedTagLibraryIds();
        ArrayList<IProject> referencedProjects = new ArrayList<IProject>(allReferencedTagLibraryIds.length);
        int i = 0;
        while (i < allReferencedTagLibraryIds.length) {
            IProject refProject = InternalJET2Platform.getDefault().getProjectDefiningTagLibrary(allReferencedTagLibraryIds[i]);
            if (refProject != null) {
                referencedProjects.add(refProject);
                if (DEBUG) {
                    System.out.println("     depends on:" + refProject);
                }
            }
            ++i;
        }
        return referencedProjects.toArray(new IProject[referencedProjects.size()]);
    }

    public IJETCompilerState getCompilerState() {
        return this.compilerState;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IPath location) throws CoreException {
        block13: {
            fileStream = null;
            objStream = null;
            try {
                try {
                    file = location.toFile();
                    file.getParentFile().mkdirs();
                    fileStream = new FileOutputStream(file);
                    objStream = new ObjectOutputStream(fileStream);
                    objStream.writeObject(this.compilerState);
                }
                catch (IOException e) {
                    throw new CoreException(InternalJET2Platform.newStatus(4, e.getLocalizedMessage(), e));
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                if (objStream != null) {
                    try {
                        objStream.close();
                    }
                    catch (IOException e) {
                        JETActivatorWrapper.INSTANCE.log(e);
                    }
                }
                if (fileStream == null) throw var6_6;
                try {
                    fileStream.close();
                    throw var6_6;
                }
                catch (IOException e) {
                    JETActivatorWrapper.INSTANCE.log(e);
                }
                throw var6_6;
            }
            {
                var5_8 = null;
                if (objStream == null) break block13;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 86->93)] { 
lbl34:
            // 1 sources

            objStream.close();
            break block13;
lbl36:
            // 1 sources

            catch (IOException e) {
                JETActivatorWrapper.INSTANCE.log(e);
            }
        }
        if (fileStream == null) return;
        try {}
        catch (IOException e) {
            JETActivatorWrapper.INSTANCE.log(e);
            return;
        }
        fileStream.close();
    }

    public String getStateFileName() {
        return "compilerState.tmp";
    }
}

